/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.parse;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.dom.AbortStatement;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.AnnotatableModuleElement;
import org.eclipse.epsilon.eol.dom.AnnotationBlock;
import org.eclipse.epsilon.eol.dom.AssignmentStatement;
import org.eclipse.epsilon.eol.dom.BooleanLiteral;
import org.eclipse.epsilon.eol.dom.BreakStatement;
import org.eclipse.epsilon.eol.dom.Case;
import org.eclipse.epsilon.eol.dom.CollectionLiteralExpression;
import org.eclipse.epsilon.eol.dom.ComplexOperationCallExpression;
import org.eclipse.epsilon.eol.dom.ContinueStatement;
import org.eclipse.epsilon.eol.dom.DeleteStatement;
import org.eclipse.epsilon.eol.dom.DivOperatorExpression;
import org.eclipse.epsilon.eol.dom.DoubleEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.ElvisOperatorExpression;
import org.eclipse.epsilon.eol.dom.EnumerationLiteralExpression;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.ExecutableAnnotation;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.ExpressionInBrackets;
import org.eclipse.epsilon.eol.dom.ExpressionStatement;
import org.eclipse.epsilon.eol.dom.FeatureCallExpression;
import org.eclipse.epsilon.eol.dom.FirstOrderOperationCallExpression;
import org.eclipse.epsilon.eol.dom.ForStatement;
import org.eclipse.epsilon.eol.dom.GreaterEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.GreaterThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.eol.dom.IfStatement;
import org.eclipse.epsilon.eol.dom.ImpliesOperatorExpression;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.dom.IntegerLiteral;
import org.eclipse.epsilon.eol.dom.ItemSelectorExpression;
import org.eclipse.epsilon.eol.dom.LessEqualOperatorExpression;
import org.eclipse.epsilon.eol.dom.LessThanOperatorExpression;
import org.eclipse.epsilon.eol.dom.MapLiteralExpression;
import org.eclipse.epsilon.eol.dom.MinusOperatorExpression;
import org.eclipse.epsilon.eol.dom.ModelDeclaration;
import org.eclipse.epsilon.eol.dom.ModelDeclarationParameter;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NegativeOperatorExpression;
import org.eclipse.epsilon.eol.dom.NewInstanceExpression;
import org.eclipse.epsilon.eol.dom.NotEqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.dom.OperationCallExpression;
import org.eclipse.epsilon.eol.dom.OperatorExpression;
import org.eclipse.epsilon.eol.dom.OrOperatorExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.PlusOperatorExpression;
import org.eclipse.epsilon.eol.dom.PostfixOperatorExpression;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.RealLiteral;
import org.eclipse.epsilon.eol.dom.ReturnStatement;
import org.eclipse.epsilon.eol.dom.SimpleAnnotation;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.dom.StringLiteral;
import org.eclipse.epsilon.eol.dom.SwitchStatement;
import org.eclipse.epsilon.eol.dom.TernaryExpression;
import org.eclipse.epsilon.eol.dom.ThrowStatement;
import org.eclipse.epsilon.eol.dom.TimesOperatorExpression;
import org.eclipse.epsilon.eol.dom.TransactionStatement;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.dom.VariableDeclaration;
import org.eclipse.epsilon.eol.dom.WhileStatement;
import org.eclipse.epsilon.eol.dom.XorOperatorExpression;

public class EolUnparser
implements IEolVisitor {
    protected StringBuffer buffer = new StringBuffer();
    protected EolModule module = null;
    protected int indentation = 0;

    public String unparse(EolModule module) {
        this.module = module;
        this.buffer = new StringBuffer();
        module.getImports().stream().forEach(i -> {
            i.accept(this);
            this.newline();
        });
        module.getDeclaredModelDeclarations().stream().forEach(md -> {
            md.accept(this);
            this.newline();
        });
        this.unparseMain();
        module.getDeclaredOperations().stream().forEach(o -> {
            this.newline();
            o.accept(this);
        });
        return this.buffer.toString();
    }

    public String getCode() {
        return this.buffer.toString();
    }

    protected void unparseMain() {
        this.module.getMain().accept(this);
    }

    protected void newline() {
        this.buffer.append(System.lineSeparator());
    }

    protected void comma() {
        this.buffer.append(", ");
    }

    protected void space() {
        this.buffer.append(' ');
    }

    protected void startCurlybrace() {
        this.buffer.append('{');
    }

    protected void endCurlybrace() {
        this.buffer.append('}');
    }

    protected void plusIndentationAndAppend() {
        ++this.indentation;
        this.indent();
    }

    protected void minusIndentationAndAppend() {
        --this.indentation;
        this.indent();
    }

    protected void spaceCurlybraceNewlineIndent() {
        this.space();
        this.startCurlybrace();
        this.newline();
        this.plusIndentationAndAppend();
    }

    protected void newlineUnindentCurlybrace() {
        this.newline();
        this.minusIndentationAndAppend();
        this.endCurlybrace();
    }

    @Override
    public void visit(AbortStatement abortStatement) {
        this.buffer.append("abort;");
    }

    @Override
    public void visit(AndOperatorExpression andOperatorExpression) {
        this.unparseBinaryOperatorExpression(andOperatorExpression, "and");
    }

    @Override
    public void visit(DeleteStatement deleteStatement) {
        this.buffer.append("delete ");
        if (deleteStatement.getExpression() != null) {
            deleteStatement.getExpression().accept(this);
        }
        this.semicolon();
    }

    protected void semicolon() {
        this.buffer.append(";");
    }

    @Override
    public void visit(AssignmentStatement assignmentStatement) {
        assignmentStatement.getTargetExpression().accept(this);
        this.buffer.append(" = ");
        assignmentStatement.getValueExpression().accept(this);
        this.buffer.append(";");
    }

    @Override
    public void visit(BooleanLiteral booleanLiteral) {
        this.buffer.append(booleanLiteral.getValue());
    }

    @Override
    public void visit(BreakStatement breakStatement) {
        this.buffer.append(breakStatement.isAll() ? "breakAll" : "break");
        this.semicolon();
    }

    @Override
    public void visit(Case case_) {
        if (case_.getCondition() != null) {
            this.buffer.append("case ");
            case_.getCondition().accept(this);
        } else {
            this.buffer.append("default");
        }
        this.buffer.append(": ");
        case_.getBody().accept(this);
    }

    @Override
    public void visit(CollectionLiteralExpression<?> collectionLiteralExpression) {
        this.buffer.append(String.valueOf(collectionLiteralExpression.getCollectionType()) + "{");
        Iterator<Expression> li = collectionLiteralExpression.getParameterExpressions().iterator();
        while (li.hasNext()) {
            li.next().accept(this);
            if (!li.hasNext()) continue;
            if (collectionLiteralExpression.isRange()) {
                this.buffer.append("..");
                continue;
            }
            this.comma();
        }
        this.buffer.append("}");
    }

    @Override
    public void visit(ComplexOperationCallExpression complexOperationCallExpression) {
    }

    @Override
    public void visit(ContinueStatement continueStatement) {
        this.buffer.append("continue;");
    }

    @Override
    public void visit(DivOperatorExpression divOperatorExpression) {
        this.unparseBinaryOperatorExpression(divOperatorExpression, "/");
    }

    @Override
    public void visit(DoubleEqualsOperatorExpression doubleEqualsOperatorExpression) {
        this.unparseBinaryOperatorExpression(doubleEqualsOperatorExpression, "==");
    }

    @Override
    public void visit(ElvisOperatorExpression elvisOperatorExpression) {
        elvisOperatorExpression.getFirstOperand().accept(this);
        this.buffer.append(" ?: ");
        elvisOperatorExpression.getSecondOperand().accept(this);
    }

    @Override
    public void visit(EnumerationLiteralExpression enumerationLiteralExpression) {
        this.buffer.append(enumerationLiteralExpression.getEnumerationLiteral());
    }

    @Override
    public void visit(EqualsOperatorExpression equalsOperatorExpression) {
        this.unparseBinaryOperatorExpression(equalsOperatorExpression, "=");
    }

    @Override
    public void visit(ExecutableBlock<?> executableBlock) {
    }

    @Override
    public void visit(ExpressionInBrackets expressionInBrackets) {
        this.buffer.append("(");
        this.unparse(expressionInBrackets.getExpression());
        this.buffer.append(")");
    }

    @Override
    public void visit(ExpressionStatement expressionStatement) {
        this.unparse(expressionStatement.getExpression());
        this.semicolon();
    }

    protected void unparse(Expression expression) {
        if (expression != null) {
            expression.accept(this);
        }
    }

    @Override
    public void visit(FirstOrderOperationCallExpression operationCallExpression) {
        this.unparse(operationCallExpression.getTargetExpression());
        this.arrowOrDot(operationCallExpression);
        this.buffer.append(String.valueOf(operationCallExpression.getName()) + "(");
        Iterator<Parameter> pi = operationCallExpression.getParameters().iterator();
        while (pi.hasNext()) {
            pi.next().accept(this);
            if (!pi.hasNext()) continue;
            this.comma();
        }
        if (!operationCallExpression.getExpressions().isEmpty()) {
            this.buffer.append("|");
            Iterator<Expression> ei = operationCallExpression.getExpressions().iterator();
            while (ei.hasNext()) {
                ei.next().accept(this);
                if (!ei.hasNext()) continue;
                this.comma();
            }
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(ForStatement forStatement) {
        this.buffer.append("for (");
        forStatement.getIteratorParameter().accept(this);
        this.buffer.append(" in ");
        forStatement.getIteratedExpression().accept(this);
        this.buffer.append(") ");
        forStatement.getBodyStatementBlock().accept(this);
    }

    @Override
    public void visit(GreaterEqualOperatorExpression greaterEqualOperatorExpression) {
        this.unparseBinaryOperatorExpression(greaterEqualOperatorExpression, ">=");
    }

    @Override
    public void visit(GreaterThanOperatorExpression greaterThanOperatorExpression) {
        this.unparseBinaryOperatorExpression(greaterThanOperatorExpression, ">");
    }

    @Override
    public void visit(IfStatement ifStatement) {
        this.buffer.append("if (");
        this.unparse(ifStatement.getConditionExpression());
        this.buffer.append(") ");
        ifStatement.getThenStatementBlock().accept(this);
        if (ifStatement.getElseStatementBlock() != null) {
            this.newline();
            this.indent();
            this.buffer.append("else ");
            StatementBlock elseStatementBlock = ifStatement.getElseStatementBlock();
            if (elseStatementBlock.getStatements().size() == 1 && elseStatementBlock.getStatements().get(0) instanceof IfStatement) {
                elseStatementBlock.getStatements().get(0).accept(this);
            } else {
                ifStatement.getElseStatementBlock().accept(this);
            }
        }
    }

    @Override
    public void visit(ImpliesOperatorExpression impliesOperatorExpression) {
        this.unparseBinaryOperatorExpression(impliesOperatorExpression, "implies");
    }

    @Override
    public void visit(Import import_) {
        this.buffer.append("import \"" + import_.getPath() + "\";");
    }

    @Override
    public void visit(IntegerLiteral integerLiteral) {
        this.buffer.append(integerLiteral.getText());
    }

    @Override
    public void visit(ItemSelectorExpression itemSelectorExpression) {
        itemSelectorExpression.getTargetExpression().accept(this);
        this.buffer.append("[");
        itemSelectorExpression.getIndexExpression().accept(this);
        this.buffer.append("]");
    }

    @Override
    public void visit(LessEqualOperatorExpression lessEqualOperatorExpression) {
        this.unparseBinaryOperatorExpression(lessEqualOperatorExpression, "<=");
    }

    @Override
    public void visit(LessThanOperatorExpression lessThanOperatorExpression) {
        this.unparseBinaryOperatorExpression(lessThanOperatorExpression, "<");
    }

    @Override
    public void visit(MapLiteralExpression<?, ?> mapLiteralExpression) {
        this.buffer.append(mapLiteralExpression.getMapName()).append("{");
        Iterator<Map.Entry<Expression, Expression>> li = mapLiteralExpression.getKeyValueExpressionPairs().iterator();
        while (li.hasNext()) {
            Map.Entry<Expression, Expression> next = li.next();
            next.getKey().accept(this);
            this.buffer.append(" = ");
            next.getValue().accept(this);
            if (!li.hasNext()) continue;
            this.comma();
        }
        this.buffer.append("}");
    }

    @Override
    public void visit(MinusOperatorExpression minusOperatorExpression) {
        this.unparseBinaryOperatorExpression(minusOperatorExpression, "-");
    }

    @Override
    public void visit(ModelDeclaration modelDeclaration) {
        Iterator<AbstractModuleElement> li;
        this.buffer.append("model ");
        modelDeclaration.getNameExpression().accept(this);
        if (!modelDeclaration.getAliasNameExpressions().isEmpty()) {
            this.buffer.append(" alias ");
            li = modelDeclaration.getAliasNameExpressions().iterator();
            while (li.hasNext()) {
                li.next().accept(this);
                if (!li.hasNext()) continue;
                this.comma();
            }
        }
        this.buffer.append(" driver ");
        modelDeclaration.getDriverNameExpression().accept(this);
        this.buffer.append(" {");
        li = modelDeclaration.getModelDeclarationParameters().iterator();
        while (li.hasNext()) {
            ((ModelDeclarationParameter)li.next()).accept(this);
            if (!li.hasNext()) continue;
            this.comma();
        }
        this.buffer.append("}");
    }

    @Override
    public void visit(ModelDeclarationParameter modelDeclarationParameter) {
        this.buffer.append(modelDeclarationParameter.getKey());
        this.buffer.append(" = \"");
        this.buffer.append(modelDeclarationParameter.getValue());
        this.buffer.append("\"");
    }

    @Override
    public void visit(NameExpression nameExpression) {
        this.buffer.append(nameExpression.getName());
    }

    @Override
    public void visit(NegativeOperatorExpression negativeOperatorExpression) {
        this.buffer.append("-");
        this.unparse(negativeOperatorExpression.getFirstOperand());
    }

    @Override
    public void visit(NewInstanceExpression newInstanceExpression) {
        this.buffer.append("new ");
        newInstanceExpression.getTypeExpression().accept(this);
        if (!newInstanceExpression.getParameterExpressions().isEmpty()) {
            this.buffer.append("(");
            Iterator<Expression> li = newInstanceExpression.getParameterExpressions().iterator();
            while (li.hasNext()) {
                li.next().accept(this);
                if (!li.hasNext()) continue;
                this.comma();
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(NotEqualsOperatorExpression notEqualsOperatorExpression) {
        this.unparseBinaryOperatorExpression(notEqualsOperatorExpression, notEqualsOperatorExpression.getOperator() != null ? notEqualsOperatorExpression.getOperator() : "<>");
    }

    @Override
    public void visit(NotOperatorExpression notOperatorExpression) {
        this.buffer.append("not ");
        notOperatorExpression.getFirstOperand().accept(this);
    }

    @Override
    public void visit(Operation operation) {
        this.unparseAnnotations(operation);
        this.buffer.append("operation ");
        if (operation.getContextTypeExpression() != null) {
            operation.getContextTypeExpression().accept(this);
            this.space();
        }
        this.buffer.append(String.valueOf(operation.getName()) + "(");
        Iterator<Parameter> li = operation.getFormalParameters().iterator();
        while (li.hasNext()) {
            li.next().accept(this);
            if (!li.hasNext()) continue;
            this.comma();
        }
        this.buffer.append(") ");
        if (operation.getReturnTypeExpression() != null) {
            this.buffer.append(": ");
            operation.getReturnTypeExpression().accept(this);
            this.space();
        }
        operation.getBody().accept(this);
    }

    @Override
    public void visit(OperationCallExpression operationCallExpression) {
        if (operationCallExpression.getTargetExpression() != null) {
            this.unparse(operationCallExpression.getTargetExpression());
            this.arrowOrDot(operationCallExpression);
        }
        this.buffer.append(String.valueOf(operationCallExpression.getName()) + "(");
        Iterator<Expression> li = operationCallExpression.getParameterExpressions().iterator();
        while (li.hasNext()) {
            li.next().accept(this);
            if (!li.hasNext()) continue;
            this.comma();
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(OrOperatorExpression orOperatorExpression) {
        this.unparseBinaryOperatorExpression(orOperatorExpression, "or");
    }

    @Override
    public void visit(Parameter parameter) {
        this.buffer.append(parameter.getName());
        if (parameter.getTypeExpression() != null) {
            this.buffer.append(" : ");
            parameter.getTypeExpression().accept(this);
        }
    }

    @Override
    public void visit(PlusOperatorExpression plusOperatorExpression) {
        this.unparseBinaryOperatorExpression(plusOperatorExpression, "+");
    }

    @Override
    public void visit(PostfixOperatorExpression postfixOperatorExpression) {
        postfixOperatorExpression.getFirstOperand().accept(this);
        this.buffer.append(postfixOperatorExpression.isIncrease() ? "++" : "--");
    }

    @Override
    public void visit(PropertyCallExpression propertyCallExpression) {
        propertyCallExpression.getTargetExpression().accept(this);
        this.arrowOrDot(propertyCallExpression);
        propertyCallExpression.getNameExpression().accept(this);
    }

    @Override
    public void visit(RealLiteral realLiteral) {
        this.buffer.append(realLiteral.getText());
    }

    @Override
    public void visit(ReturnStatement returnStatement) {
        this.buffer.append("return");
        if (returnStatement.getReturnedExpression() != null) {
            this.buffer.append(" ");
            returnStatement.getReturnedExpression().accept(this);
        }
        this.semicolon();
    }

    @Override
    public void visit(AnnotationBlock annotationBlock) {
        annotationBlock.getAnnotations().forEach(a -> {
            this.indent();
            a.accept(this);
            this.newline();
        });
    }

    @Override
    public void visit(SimpleAnnotation simpleAnnotation) {
        this.buffer.append("@" + simpleAnnotation.getName());
        if (simpleAnnotation.getValue() != null) {
            this.buffer.append(" " + simpleAnnotation.getValue());
        }
    }

    @Override
    public void visit(ExecutableAnnotation executableAnnotation) {
        this.buffer.append("$" + executableAnnotation.getName());
        if (executableAnnotation.getExpression() != null) {
            this.space();
            executableAnnotation.getExpression().accept(this);
        }
    }

    @Override
    public void visit(StatementBlock statementBlock) {
        if (this.module == null || statementBlock != this.module.getMain()) {
            this.buffer.append("{");
            this.newline();
            ++this.indentation;
        }
        statementBlock.getStatements().forEach(s -> {
            this.indent();
            s.accept(this);
            this.newline();
        });
        if (this.module == null || statementBlock != this.module.getMain()) {
            --this.indentation;
            this.indent();
            this.buffer.append("}");
        }
    }

    protected void indent() {
        int i = 0;
        while (i < this.indentation) {
            this.buffer.append("\t");
            ++i;
        }
    }

    @Override
    public void visit(StringLiteral stringLiteral) {
        this.buffer.append("\"" + EolUnparser.escape((String)stringLiteral.getValue()) + "\"");
    }

    public static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\"");
    }

    @Override
    public void visit(SwitchStatement switchStatement) {
        this.buffer.append("switch (");
        switchStatement.getConditionExpression().accept(this);
        this.buffer.append(") {");
        this.newline();
        ++this.indentation;
        switchStatement.getCases().forEach(c -> {
            this.indent();
            c.accept(this);
            this.newline();
        });
        if (switchStatement.getDefault() != null) {
            this.indent();
            switchStatement.getDefault().accept(this);
            this.newline();
        }
        --this.indentation;
        this.indent();
        this.buffer.append("}");
    }

    @Override
    public void visit(TernaryExpression ternaryExpression) {
        ternaryExpression.getFirstOperand().accept(this);
        this.buffer.append(" ? ");
        ternaryExpression.getSecondOperand().accept(this);
        this.buffer.append(" : ");
        ternaryExpression.getThirdOperand().accept(this);
    }

    @Override
    public void visit(ThrowStatement throwStatement) {
        this.buffer.append("throw");
        if (throwStatement.getThrown() != null) {
            this.buffer.append(" ");
            throwStatement.getThrown().accept(this);
        }
        this.semicolon();
    }

    @Override
    public void visit(TimesOperatorExpression timesOperatorExpression) {
        this.unparseBinaryOperatorExpression(timesOperatorExpression, "*");
    }

    protected void unparseBinaryOperatorExpression(OperatorExpression operatorExpression, String operator) {
        operatorExpression.getFirstOperand().accept(this);
        this.buffer.append(" " + operator + " ");
        operatorExpression.getSecondOperand().accept(this);
    }

    protected void arrowOrDot(FeatureCallExpression expression) {
        if (expression.isNullSafe()) {
            this.buffer.append("?");
        }
        this.buffer.append(expression.isArrow() ? "->" : ".");
    }

    @Override
    public void visit(TransactionStatement transactionStatement) {
        this.buffer.append("transaction ");
        Iterator<NameExpression> li = transactionStatement.getModelNames().iterator();
        while (li.hasNext()) {
            li.next().accept(this);
            if (li.hasNext()) {
                this.comma();
                continue;
            }
            this.space();
        }
        transactionStatement.getBody().accept(this);
    }

    @Override
    public void visit(TypeExpression typeExpression) {
        this.buffer.append(typeExpression.getName());
        if (typeExpression.getNativeType() != null) {
            this.buffer.append("(");
            typeExpression.getNativeType().accept(this);
            this.buffer.append(")");
        } else if (!typeExpression.getParameterTypeExpressions().isEmpty()) {
            this.buffer.append("(");
            Iterator<TypeExpression> li = typeExpression.getParameterTypeExpressions().iterator();
            while (li.hasNext()) {
                li.next().accept(this);
                if (!li.hasNext()) continue;
                this.comma();
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(VariableDeclaration variableDeclaration) {
        this.buffer.append("var " + variableDeclaration.getName());
        if (variableDeclaration.getTypeExpression() != null) {
            this.buffer.append(" : ");
            if (variableDeclaration.isInstantiate()) {
                this.buffer.append("new ");
            }
            variableDeclaration.getTypeExpression().accept(this);
        }
    }

    @Override
    public void visit(WhileStatement whileStatement) {
        this.buffer.append("while (");
        this.unparse(whileStatement.getConditionExpression());
        this.buffer.append(")");
        whileStatement.getBodyStatementBlock().accept(this);
    }

    @Override
    public void visit(XorOperatorExpression xorOperatorExpression) {
        this.unparseBinaryOperatorExpression(xorOperatorExpression, "xor");
    }

    protected void unparseAnnotations(AnnotatableModuleElement annotatableModuleElement) {
        if (annotatableModuleElement.getAnnotationBlock() != null) {
            annotatableModuleElement.getAnnotationBlock().accept(this);
        }
    }
}

