/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.eol.dom.StringLiteral;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolTypeNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;

public class EolNativeType
extends EolAnyType {
    protected IEolContext context;
    protected String clazz;
    protected IToolNativeTypeDelegate delegate;

    public EolNativeType(Class<?> actualClass, IEolContext context) {
        this.clazz = actualClass.getCanonicalName();
        this.context = context;
        for (IToolNativeTypeDelegate delegate : context.getNativeTypeDelegates()) {
            if (!delegate.knowsAbout(this.clazz)) continue;
            this.delegate = delegate;
            return;
        }
    }

    public EolNativeType(StringLiteral classAst, IEolContext context) throws EolTypeNotFoundException {
        for (IToolNativeTypeDelegate delegate : context.getNativeTypeDelegates()) {
            if (!delegate.knowsAbout((String)classAst.getValue())) continue;
            this.clazz = (String)classAst.getValue();
            this.delegate = delegate;
            this.context = context;
            return;
        }
        throw new EolTypeNotFoundException((String)classAst.getValue(), classAst);
    }

    @Override
    public Object createInstance() throws EolRuntimeException {
        return this.delegate.createInstance(this.clazz, Collections.emptyList(), this.context);
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        return this.delegate.createInstance(this.clazz, parameters, this.context);
    }

    public Class<?> getJavaClass() {
        try {
            return ClassLoader.getSystemClassLoader().loadClass(this.clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "Native (" + this.clazz + ")";
    }

    @Override
    public boolean isKind(Object o) {
        if (o != null) {
            Class<?> cls = o.getClass();
            boolean found = false;
            while (cls != null && !found) {
                if (cls.getCanonicalName().equalsIgnoreCase(this.clazz)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
        }
        return false;
    }

    @Override
    public boolean isType(Object o) {
        return o != null && o.getClass().getCanonicalName().equalsIgnoreCase(this.clazz);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.clazz);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof EolNativeType) {
            return ((EolNativeType)o).clazz.equalsIgnoreCase(this.clazz);
        }
        return false;
    }
}

