/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collection;
import java.util.Map;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolMap;

public class EolTuple
extends EolMap<String, Object> {
    public EolTuple() {
    }

    public EolTuple(Map<String, ?> properties) {
        if (properties != null) {
            this.putAll(properties);
        }
    }

    public EolTuple(Collection<? extends Variable> variables) {
        if (variables != null) {
            for (Variable variable : variables) {
                this.put(variable.getName(), variable.getValue());
            }
        }
    }

    public boolean hasProperty(String property) {
        return this.containsKey(property);
    }

    public Object getOrThrow(String property, IEolContext context) throws EolIllegalPropertyException {
        if (!this.containsKey(property)) {
            throw new EolIllegalPropertyException(this, property, context);
        }
        return this.get(property);
    }

    public Object put(Variable variable) {
        if (variable != null) {
            return this.put(variable.getName(), variable.getValue());
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EolTuple)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Tuple {" + this.wrapped + "}";
    }
}

