/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolAnyType;

public abstract class EolType {
    public abstract String getName();

    public abstract boolean isType(Object var1);

    public abstract boolean isKind(Object var1);

    public abstract Object createInstance() throws EolRuntimeException;

    public abstract Object createInstance(List<Object> var1) throws EolRuntimeException;

    public boolean isNot(EolType type) {
        return this != type && this != EolAnyType.Instance;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        EolType eolType = (EolType)other;
        return Objects.equals(this.getName(), eolType.getName());
    }

    public List<EolType> getParentTypes() {
        EolType parentType = this.getParentType();
        if (parentType == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(parentType);
    }

    protected EolType getParentType() {
        return EolAnyType.Instance;
    }
}

