/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolNativeType;

public class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static boolean hasMethods(Object obj, String methodName) {
        if (obj == null) {
            return false;
        }
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ReflectionUtil.getMethodName(method).equals(methodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Set<String> getMethodNames(Object obj, boolean includeInheritedMethods) {
        if (obj == null) {
            return new HashSet<String>(0);
        }
        Method[] methods = ReflectionUtil.getMethods(obj, includeInheritedMethods);
        HashSet<String> methodNames = new HashSet<String>(methods.length);
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            methodNames.add(ReflectionUtil.getMethodName(method));
            ++n2;
        }
        return methodNames;
    }

    protected static String getMethodName(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("_")) {
            methodName = methodName.substring(1);
        }
        return methodName;
    }

    public static Method findApplicableMethodOrThrow(Object obj, String methodName, Predicate<Method> criteria, Collection<?> parameters, ModuleElement ast, PrettyPrinterManager ppm) throws EolIllegalOperationException, EolIllegalOperationParametersException {
        Method[] candidates = ReflectionUtil.getMethodsFromPublicClassesForName(obj, methodName);
        Method method = Stream.of(candidates).filter(criteria).findAny().orElse(null);
        if (method == null) {
            method = ReflectionUtil.searchMethodsFor(candidates, methodName, parameters.toArray(), true);
        }
        if (method == null) {
            Collector<CharSequence, ?, String> paramJoiner = Collectors.joining(", ");
            if (candidates.length > 0) {
                String expectedParams = Stream.of(candidates[0].getParameterTypes()).map(Class::getTypeName).collect(paramJoiner);
                String actualParams = parameters.stream().map(expr -> expr.getClass().getTypeName()).collect(paramJoiner);
                throw new EolIllegalOperationParametersException(methodName, expectedParams, actualParams, ast);
            }
            throw new EolIllegalOperationException(obj, methodName, ast, ppm);
        }
        return method;
    }

    public static Class<?>[] discoverPublicClasses(Class<?> clazz) {
        ArrayList interfaces = new ArrayList();
        ReflectionUtil.discoverPublicClasses(clazz, interfaces);
        Collections.reverse(interfaces);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static void discoverPublicClasses(Class<?> clazz, List<Class<?>> interfaces) {
        if (clazz == null) {
            return;
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            interfaces.add(clazz);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            ReflectionUtil.discoverPublicClasses(superInterface, interfaces);
            ++n2;
        }
        ReflectionUtil.discoverPublicClasses(clazz.getSuperclass(), interfaces);
    }

    public static Method[] getMethodsFromPublicClassesForName(Object obj, String methodName) {
        Class<?> clazz = obj instanceof EolNativeType ? ((EolNativeType)obj).getJavaClass() : obj.getClass();
        return (Method[])Stream.of(ReflectionUtil.discoverPublicClasses(clazz)).flatMap(c -> Arrays.stream(c.getMethods())).filter(m -> ReflectionUtil.getMethodName(m).equals(methodName)).toArray(Method[]::new);
    }

    private static Method[] getMethods(Object obj, boolean includeInheritedMethods) {
        Class<?> clazz = obj.getClass();
        if (includeInheritedMethods) {
            return clazz.getMethods();
        }
        return clazz.getDeclaredMethods();
    }

    public static Method getMethodFor(Object obj, String methodName, Object[] parameters, boolean includeInheritedMethods, boolean allowContravariantConversionForParameters) {
        if (obj == null) {
            return null;
        }
        Method instanceMethod = ReflectionUtil.getInstanceMethodFor(obj, methodName, parameters, includeInheritedMethods, allowContravariantConversionForParameters);
        if (instanceMethod != null) {
            return instanceMethod;
        }
        Method staticMethod = ReflectionUtil.getStaticMethodFor(obj, methodName, parameters, allowContravariantConversionForParameters);
        if (staticMethod != null) {
            return staticMethod;
        }
        return null;
    }

    private static Method getInstanceMethodFor(Object obj, String methodName, Object[] parameters, boolean includeInheritedMethods, boolean allowContravariantConversionForParameters) {
        return ReflectionUtil.searchMethodsFor(ReflectionUtil.getMethods(obj, includeInheritedMethods), methodName, parameters, allowContravariantConversionForParameters);
    }

    private static Method getStaticMethodFor(Object obj, String methodName, Object[] parameters, boolean allowContravariantConversionForParameters) {
        Method staticMethod = null;
        Class javaClass = null;
        if (obj instanceof EolNativeType) {
            javaClass = ((EolNativeType)obj).getJavaClass();
        }
        if (obj instanceof Class) {
            javaClass = (Class)obj;
        }
        if (javaClass != null) {
            staticMethod = ReflectionUtil.searchMethodsFor(javaClass.getMethods(), methodName, parameters, allowContravariantConversionForParameters);
        }
        return staticMethod;
    }

    /*
     * Unable to fully structure code
     */
    private static Method searchMethodsFor(Method[] methods, String methodName, Object[] parameters, boolean allowContravariantConversionForParameters) {
        stage = 0;
        while (stage < 2) {
            var8_8 = methods;
            var7_7 = methods.length;
            var6_6 = 0;
            while (var6_6 < var7_7) {
                method = var8_8[var6_6];
                if (ReflectionUtil.getMethodName(method).equalsIgnoreCase(methodName)) {
                    parameterTypes = method.getParameterTypes();
                    isVarargs = method.isVarArgs();
                    v0 = parametersMatch = parameterTypes.length == parameters.length || isVarargs != false;
                    if (parametersMatch) {
                        varargIndex = method.getParameterCount() - 1;
                        v1 = endIndex = isVarargs != false ? varargIndex : parameterTypes.length;
                        if (parameters.length >= endIndex) {
                            j = 0;
                            while (j < endIndex && parametersMatch) {
                                parameterType = parameterTypes[j];
                                parameter = parameters[j];
                                parametersMatch = allowContravariantConversionForParameters != false ? parametersMatch != false && (stage == 0 ? parameterType.isInstance(parameter) != false : ReflectionUtil.isInstance(parameterType, parameter) != false) : parametersMatch != false && parameterType.equals(parameter.getClass()) != false;
                                ++j;
                            }
                            if (isVarargs) {
                                varargType = parameterTypes[varargIndex].getComponentType();
                                va = varargIndex;
                                while (va < parameters.length && parametersMatch) {
                                    parameter = parameters[va];
                                    parametersMatch = stage == 0 ? varargType.isInstance(parameter) : ReflectionUtil.isInstance(varargType, parameter);
                                    ++va;
                                }
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (parametersMatch) {
                        return method;
                    }
                }
                ++var6_6;
            }
            ++stage;
        }
        return null;
    }

    public static Object executeMethod(Object obj, String methodName, Object ... parameters) throws Throwable {
        Method method = ReflectionUtil.getMethodFor(obj, methodName, parameters, true, true);
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(obj, parameters);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Object executeMethod(Object obj, Method method, ModuleElement ast, Object ... parameters) throws EolRuntimeException {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(obj, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ix) {
            Throwable cause = ix.getCause();
            if (cause == null) {
                cause = ix;
            }
            throw new EolInternalException(cause, ast);
        }
    }

    public static Method getLegalMethod(Object obj, Method method) {
        Method[] methodArray = ReflectionUtil.getMethodsFromPublicClassesForName(obj, method.getName());
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Objects.deepEquals(m.getParameterTypes(), method.getParameterTypes()) && m.getClass().isAssignableFrom(method.getClass())) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    public static String methodToString(Method method) {
        String str = ReflectionUtil.getMethodName(method);
        str = String.valueOf(str) + "(";
        int i = 0;
        while (i < method.getParameterTypes().length) {
            Class<?> parameterType = method.getParameterTypes()[i];
            str = String.valueOf(str) + parameterType.getName();
            if (i < method.getParameterTypes().length - 1) {
                str = String.valueOf(str) + " ,";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        Field field = ReflectionUtil.getField(object.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(fieldName)) {
                return fields[i];
            }
            ++i;
        }
        if (clazz.getSuperclass() != Object.class) {
            return ReflectionUtil.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }

    public static boolean isInstance(Class<?> clazz, Object instance) {
        if (instance == null) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class.isInstance(instance);
        }
        if (clazz == Float.TYPE) {
            return Float.class.isInstance(instance);
        }
        if (clazz == Double.TYPE) {
            return Double.class.isInstance(instance);
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class.isInstance(instance);
        }
        if (clazz == Long.TYPE) {
            return Long.class.isInstance(instance);
        }
        if (clazz == Character.TYPE) {
            return Character.class.isInstance(instance);
        }
        return clazz.isInstance(instance);
    }

    public static List<Field> getAllInheritedInstanceFields(Class<?> klazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fieldArray = klazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!Modifier.isStatic(f.getModifiers())) {
                fields.add(f);
            }
            ++n2;
        }
        if (klazz.getSuperclass() != null) {
            fields.addAll(ReflectionUtil.getAllInheritedInstanceFields(klazz.getSuperclass()));
        }
        return fields;
    }
}

