/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.exceptions.EolIllegalReturnException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.Return;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.epl.IEplModule;
import org.eclipse.epsilon.epl.dom.Cardinality;
import org.eclipse.epsilon.epl.dom.Domain;
import org.eclipse.epsilon.epl.dom.NoMatch;
import org.eclipse.epsilon.epl.dom.Pattern;
import org.eclipse.epsilon.epl.dom.Role;
import org.eclipse.epsilon.epl.execute.PatternMatch;
import org.eclipse.epsilon.epl.execute.context.EplContext;
import org.eclipse.epsilon.epl.execute.context.IEplContext;
import org.eclipse.epsilon.epl.execute.model.PatternMatchModel;
import org.eclipse.epsilon.epl.parse.EplLexer;
import org.eclipse.epsilon.epl.parse.EplParser;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.execute.context.IErlContext;

public abstract class AbstractEplModule
extends ErlModule
implements IEplModule {
    public static final int INFINITE = -1;
    protected List<Pattern> patterns;
    protected final ArrayList<Pattern> declaredPatterns = new ArrayList(0);
    protected boolean repeatWhileMatchesFound = false;
    protected int maxLoops = -1;
    protected String patternMatchModelName = "P";

    public AbstractEplModule() {
        this(null);
    }

    public AbstractEplModule(IEplContext context) {
        super((IErlContext)(context != null ? context : new EplContext()));
    }

    public IEplContext getContext() {
        return (IEplContext)super.getContext();
    }

    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new EplLexer((CharStream)inputStream);
    }

    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EplParser(tokenStream);
    }

    public String getMainRule() {
        return "eplModule";
    }

    public HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap importConfiguration = super.getImportConfiguration();
        importConfiguration.put("epl", this.getClass());
        return importConfiguration;
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        switch (cst.getType()) {
            case 87: {
                return new Pattern();
            }
            case 88: {
                return new Cardinality();
            }
            case 89: {
                return new Domain();
            }
            case 90: {
                return new Role();
            }
            case 86: 
            case 91: 
            case 96: 
            case 97: {
                return new ExecutableBlock(Boolean.class);
            }
            case 92: 
            case 93: 
            case 94: {
                return new ExecutableBlock(Void.class);
            }
        }
        return super.adapt(cst, parentAst);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        List patternAsts = AstUtil.getChildren((AST)cst, (int[])new int[]{87});
        this.declaredPatterns.ensureCapacity(patternAsts.size());
        for (AST patternAst : patternAsts) {
            this.declaredPatterns.add((Pattern)module.createAst(patternAst, (ModuleElement)this));
        }
    }

    protected Object processRules() throws EolRuntimeException {
        return this.matchPatterns();
    }

    @Override
    public List<Pattern> getDeclaredPatterns() {
        return this.declaredPatterns;
    }

    @Override
    public List<Pattern> getPatterns() {
        if (this.patterns == null) {
            this.patterns = new ArrayList<Pattern>();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEplModule)) continue;
                IEplModule module = (IEplModule)import_.getModule();
                this.patterns.addAll(module.getPatterns());
            }
            this.patterns.addAll(this.declaredPatterns);
        }
        return this.patterns;
    }

    @Override
    public int getMaxLoops() {
        return this.maxLoops;
    }

    @Override
    public void setMaxLoops(int maxLoops) {
        this.maxLoops = maxLoops;
    }

    @Override
    public boolean isRepeatWhileMatches() {
        return this.repeatWhileMatchesFound;
    }

    @Override
    public void setRepeatWhileMatches(boolean repeatWhileMatches) {
        this.repeatWhileMatchesFound = repeatWhileMatches;
    }

    @Override
    public final PatternMatchModel matchPatterns() throws EolRuntimeException {
        PatternMatchModel matchModel = null;
        try {
            int loops = 0;
            do {
                matchModel = this.getContext().getPatternMatchTrace();
                this.preMatch(matchModel);
                int level = 0;
                while (level <= this.getMaximumLevel()) {
                    Set<PatternMatch> currentMatches = this.matchPatterns(level, matchModel);
                    this.postProcessMatches(level, currentMatches);
                    ++level;
                }
            } while (this.repeatWhileMatchesFound && !matchModel.allContents().isEmpty() && (++loops < this.maxLoops || this.maxLoops == -1));
        }
        catch (Exception ex) {
            EolRuntimeException.propagate((Throwable)ex);
        }
        return matchModel;
    }

    @Override
    public Collection<PatternMatch> match(Pattern pattern) throws EolRuntimeException {
        LinkedList<PatternMatch> patternMatches = new LinkedList<PatternMatch>();
        Iterator<Collection<Iterable<?>>> candidates = this.getCandidates(pattern);
        while (candidates.hasNext()) {
            this.matchCombination(candidates.next(), pattern).ifPresent(patternMatches::add);
        }
        return patternMatches;
    }

    protected final Optional<PatternMatch> matchCombination(Collection<? extends Iterable<?>> combination, Pattern pattern) throws EolRuntimeException {
        Optional<PatternMatch> result;
        FrameStack frameStack = this.context.getFrameStack();
        Frame frame = frameStack.enterLocal(FrameType.PROTECTED, (ModuleElement)pattern, new Variable[0]);
        ExecutorFactory executorFactory = this.context.getExecutorFactory();
        if (pattern.getMatch() != null || pattern.getNoMatch() != null || pattern.getOnMatch() != null) {
            AbstractEplModule.putRoleBindingsIntoFrame(pattern.getRoles(), combination, frame);
        }
        if (this.getMatchResult(pattern)) {
            executorFactory.execute(pattern.getOnMatch(), this.context);
            result = Optional.of(this.createPatternMatch(pattern, combination));
        } else {
            executorFactory.execute(pattern.getNoMatch(), this.context);
            result = Optional.empty();
        }
        frameStack.leaveLocal((ModuleElement)pattern);
        return result;
    }

    protected PatternMatchModel createModel() throws EolRuntimeException {
        return new PatternMatchModel();
    }

    protected void preMatch(PatternMatchModel model) throws EolRuntimeException {
        if (this.getMaximumLevel() > 0) {
            this.context.getModelRepository().addModel((IModel)model);
        }
        model.setPatterns(this.getPatterns());
    }

    protected Set<PatternMatch> matchPatterns(int level, PatternMatchModel model) throws EolRuntimeException {
        ArrayList<PatternMatch> currentLoopMatches = new ArrayList<PatternMatch>();
        for (Pattern pattern : this.getPatterns()) {
            if (pattern.getLevel() != level) continue;
            Collection<PatternMatch> matches = this.match(pattern);
            currentLoopMatches.addAll(matches);
            model.addMatches(matches);
        }
        model.dispose();
        model.addMatches(currentLoopMatches);
        return model.getMatches();
    }

    protected final void postProcessMatches(int level, Collection<PatternMatch> matches) throws EolRuntimeException {
        for (PatternMatch match : matches) {
            ExecutableBlock<Void> do_;
            Pattern pattern = match.getPattern();
            if (pattern.getLevel() != level || (do_ = pattern.getDo()) == null) continue;
            this.executeDoBlock(do_, match.getRoleBindings());
        }
    }

    protected Object executeDoBlock(ExecutableBlock<?> doBlock, Map<String, Object> roleBindings) throws EolRuntimeException {
        FrameStack frameStack = this.context.getFrameStack();
        Frame frame = frameStack.enterLocal(FrameType.UNPROTECTED, doBlock, new Variable[0]);
        roleBindings.entrySet().stream().map(Variable::createReadOnlyVariable).forEach(arg_0 -> ((Frame)frame).put(arg_0));
        Object result = this.context.getExecutorFactory().execute(doBlock, this.context);
        frameStack.leaveLocal(doBlock);
        return result;
    }

    protected final boolean getMatchResult(Pattern pattern) throws EolRuntimeException {
        ExecutableBlock<Boolean> matchBlock = pattern.getMatch();
        if (matchBlock != null) {
            Object result = this.context.getExecutorFactory().execute(matchBlock, this.context);
            if (result instanceof Return) {
                result = ((Return)result).getValue();
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new EolIllegalReturnException("Pattern Match result should be a Boolean.", result, matchBlock, this.context);
        }
        return true;
    }

    protected PatternMatch createPatternMatch(Pattern pattern, Collection<? extends Iterable<?>> combination) {
        PatternMatch patternMatch = new PatternMatch(pattern);
        AbstractEplModule.flatMapRoleBindings(pattern.getRoles(), combination).forEach(patternMatch::putRoleBinding);
        return patternMatch;
    }

    protected static final Collection<Variable> flatMapRoleBindings(Collection<Role> roles, Collection<? extends Iterable<?>> combination) {
        Stream<Collection> variables;
        if (combination.size() >= roles.size()) {
            Iterator<? extends Iterable<?>> combinationsIter = combination.iterator();
            variables = roles.stream().map(role -> AbstractEplModule.getVariables((Iterable)combinationsIter.next(), role));
        } else {
            Iterator<Role> rolesIter = roles.iterator();
            variables = combination.stream().map(bindings -> AbstractEplModule.getVariables(bindings, (Role)((Object)((Object)rolesIter.next()))));
        }
        return variables.flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected static Collection<Variable> getVariables(Iterable<?> bindings, Role role) {
        Iterator<?> bindingsIter = bindings.iterator();
        return role.getNames().stream().map(roleName -> Variable.createReadOnlyVariable((String)roleName, bindingsIter.next())).collect(Collectors.toList());
    }

    protected static final int putRoleBindingsIntoFrame(Collection<Role> roles, Collection<? extends Iterable<?>> combination, Frame frame) {
        Collection<Variable> variables = AbstractEplModule.flatMapRoleBindings(roles, combination);
        variables.forEach(arg_0 -> ((Frame)frame).put(arg_0));
        return variables.size();
    }

    protected boolean isValidCombination(Pattern pattern, List<? extends Iterable<?>> combination) throws EolRuntimeException {
        Role role2;
        int lastIndex = combination.size() - 1;
        List<Role> roles = pattern.getRoles();
        assert (roles.size() > lastIndex);
        FrameStack frameStack = this.context.getFrameStack();
        Frame frame = frameStack.enterLocal(FrameType.PROTECTED, (ModuleElement)pattern, new Variable[0]);
        AbstractEplModule.putRoleBindingsIntoFrame(roles, combination, frame);
        boolean result = false;
        for (Role role2 : roles) {
            result |= role2.isActive(this.context);
        }
        if (!result) {
            return false;
        }
        for (Role o : combination.get(lastIndex)) {
            if (!(o instanceof NoMatch)) continue;
            return true;
        }
        if (lastIndex >= 0 && (role2 = roles.get(lastIndex)) != null && !role2.isNegative() && role2.getGuard() != null && role2.isActive(this.context) && role2.getCardinality().isOne()) {
            result = (Boolean)role2.getGuard().execute(this.context);
        }
        frameStack.leaveLocal((ModuleElement)pattern);
        return result;
    }

    protected abstract Iterator<? extends Collection<? extends Iterable<?>>> getCandidates(Pattern var1) throws EolRuntimeException;

    protected final Collection<?> getRoleInstances(Role role, String roleName) throws EolRuntimeException {
        Collection<?> currentInstances = this.wrapBasicRoleInstances(role, roleName, this::preprocessRoleInstances);
        if (role.isNegative()) {
            return this.wrapAdvancedRoleInstances(role, roleName, currentInstances, this::getNegativeRoleInstances);
        }
        if (role.getCardinality().isMany()) {
            return this.wrapAdvancedRoleInstances(role, roleName, currentInstances, this::getAllRoleInstances);
        }
        return currentInstances;
    }

    protected abstract Collection<?> wrapBasicRoleInstances(Role var1, String var2, LazyBasicRoleInstancesInitializer var3) throws EolRuntimeException;

    protected abstract Collection<?> wrapAdvancedRoleInstances(Role var1, String var2, Collection<?> var3, LazyAdvancedRoleInstancesInitializer var4) throws EolRuntimeException;

    private final Collection<?> preprocessRoleInstances(Role role, String roleName) throws EolRuntimeException {
        EolType type = role.getType(this.context);
        if (!role.isActive(this.context, true)) {
            return NoMatch.asList();
        }
        if (role.getDomain() != null) {
            return role.getDomain().getValues(this.context, type);
        }
        if (type instanceof EolModelElementType) {
            return ((EolModelElementType)type).getAllOfKind();
        }
        throw new IllegalStateException("Don't know what to do with " + type + " for role " + roleName);
    }

    private final Collection<?> getAllRoleInstances(Role role, String roleName, Collection<?> currentInstances) throws EolRuntimeException {
        ExecutableBlock<Boolean> guard = role.getGuard();
        Collection<?> filtered = guard == null ? currentInstances : this.filterElements(guard, roleName, currentInstances);
        return role.getCardinality().isInBounds(filtered.size()) ? Collections.singletonList(filtered) : Collections.emptyList();
    }

    private final Collection<?> getNegativeRoleInstances(Role role, String roleName, Collection<?> currentInstances) throws EolRuntimeException {
        ExecutableBlock<Boolean> guard = role.getGuard();
        if (guard != null ? this.negativeGuard(guard, roleName, currentInstances) : !currentInstances.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(NoMatch.INSTANCE);
    }

    protected boolean negativeGuard(ExecutableBlock<Boolean> guard, String roleName, Collection<?> currentInstances) throws EolRuntimeException {
        for (Object element : currentInstances) {
            if (!((Boolean)guard.execute(this.context, true, new Variable[]{Variable.createReadOnlyVariable((String)roleName, element)})).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected Collection<?> filterElements(ExecutableBlock<Boolean> guard, String roleName, Collection<?> currentInstances) throws EolRuntimeException {
        ArrayList filtered = new ArrayList();
        for (Object element : currentInstances) {
            if (!((Boolean)guard.execute(this.context, true, new Variable[]{Variable.createReadOnlyVariable((String)roleName, element)})).booleanValue()) continue;
            filtered.add(element);
        }
        return filtered;
    }

    @FunctionalInterface
    protected static interface LazyAdvancedRoleInstancesInitializer {
        public Collection<?> get(Role var1, String var2, Collection<?> var3) throws EolRuntimeException;
    }

    @FunctionalInterface
    protected static interface LazyBasicRoleInstancesInitializer {
        public Collection<?> get(Role var1, String var2) throws EolRuntimeException;
    }
}

