/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.epl.AbstractEplModule;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CombinationGeneratorListener;
import org.eclipse.epsilon.epl.combinations.CompositeCombinationGenerator;
import org.eclipse.epsilon.epl.combinations.DynamicList;
import org.eclipse.epsilon.epl.combinations.DynamicListCombinationGenerator;
import org.eclipse.epsilon.epl.debug.EplDebugger;
import org.eclipse.epsilon.epl.dom.NoMatch;
import org.eclipse.epsilon.epl.dom.Pattern;
import org.eclipse.epsilon.epl.dom.Role;
import org.eclipse.epsilon.epl.execute.RuntimeExceptionThrower;
import org.eclipse.epsilon.epl.execute.context.IEplContext;

public class EplModule
extends AbstractEplModule {
    public EplModule() {
    }

    public EplModule(IEplContext context) {
        super(context);
    }

    private static List<Object> wrapGetValues(Collection<?> superReturnInstances) {
        if (superReturnInstances instanceof ArrayList || superReturnInstances instanceof DynamicList) {
            return (List)superReturnInstances;
        }
        return new ArrayList<Object>(superReturnInstances);
    }

    protected DynamicList<Object> wrapBasicRoleInstances(final Role role, final String roleName, final AbstractEplModule.LazyBasicRoleInstancesInitializer initializer) throws EolRuntimeException {
        DynamicList<Object> dynamicInstances = new DynamicList<Object>(){

            @Override
            protected List<Object> getValues() throws EolRuntimeException {
                return EplModule.wrapGetValues(initializer.get(role, roleName));
            }
        };
        dynamicInstances.setResetable(role.hasActiveAst() || role.getDomain() != null && role.getDomain().isDynamic());
        dynamicInstances.setExceptionHandler(new RuntimeExceptionThrower<EolRuntimeException>());
        return dynamicInstances;
    }

    protected DynamicList<Object> wrapAdvancedRoleInstances(final Role role, final String roleName, Collection<?> currentInstances_, final AbstractEplModule.LazyAdvancedRoleInstancesInitializer initializer) throws EolRuntimeException {
        final DynamicList currentInstances = (DynamicList)currentInstances_;
        DynamicList<Object> dynamicInstances = new DynamicList<Object>(){

            @Override
            protected List<Object> getValues() throws EolRuntimeException {
                return EplModule.wrapGetValues(initializer.get(role, roleName, currentInstances));
            }

            @Override
            public void reset() {
                super.reset();
                currentInstances.reset();
            }
        };
        dynamicInstances.setResetable(currentInstances.isResetable());
        dynamicInstances.setExceptionHandler(currentInstances.getExceptionHandler());
        return dynamicInstances;
    }

    protected final Iterator<List<List<Object>>> getCandidates(Pattern pattern) throws EolRuntimeException {
        return this.initGenerator(pattern);
    }

    protected CompositeCombinationGenerator<Object> initGenerator(Pattern pattern) throws EolRuntimeException {
        CompositeCombinationGenerator<Object> generator = new CompositeCombinationGenerator<Object>();
        for (Role role : pattern.getRoles()) {
            generator.addCombinationGenerator(this.createCombinationGenerator(role));
        }
        generator.setValidator(combination -> this.isValidCombination(pattern, combination));
        return generator;
    }

    protected CombinationGenerator<Object> createCombinationGenerator(final Role role) throws EolRuntimeException {
        DynamicListCombinationGenerator<Object> combinationGenerator = new DynamicListCombinationGenerator<Object>((List)this.getRoleInstances(role, null), role.getNames().size()){

            @Override
            public boolean checkOptional() {
                try {
                    return role.isOptional(EplModule.this.context);
                }
                catch (EolRuntimeException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        combinationGenerator.addListener(new CombinationGeneratorListener<Object>(){
            final FrameStack frameStack;
            {
                this.frameStack = EplModule.this.context.getFrameStack();
            }

            @Override
            public void generated(Collection<Object> next) {
                if (next == null) {
                    for (String name : role.getNames()) {
                        this.frameStack.put(Variable.createReadOnlyVariable((String)name, (Object)NoMatch.INSTANCE));
                    }
                } else {
                    this.frameStack.put(EplModule.getVariables(next, role));
                }
            }

            @Override
            public void reset() {
                this.frameStack.remove(role.getNames());
            }
        });
        return combinationGenerator;
    }

    public EolDebugger createDebugger() {
        return new EplDebugger();
    }
}

