/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.combinations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CompositeCombinationValidator;

public class CompositeCombinationGenerator<T>
implements CombinationGenerator<List<T>> {
    protected List<CombinationGenerator<T>> generators = new ArrayList<CombinationGenerator<T>>();
    protected int currentGeneratorIndex = 0;
    protected Stack<List<T>> currentStack = new Stack();
    protected CompositeCombinationValidator<T, EolRuntimeException> validator;
    protected final List<List<T>> NEXT = Collections.emptyList();
    protected final List<List<T>> UNKNOWN = Collections.emptyList();
    protected List<List<T>> lookahead = this.UNKNOWN;

    public static List<String> createList(String ... strings) {
        ArrayList<String> list = new ArrayList<String>(strings.length);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        return list;
    }

    public CompositeCombinationValidator<T, EolRuntimeException> getValidator() {
        return this.validator;
    }

    public void setValidator(CompositeCombinationValidator<T, EolRuntimeException> validator) {
        this.validator = validator;
    }

    public void addCombinationGenerator(CombinationGenerator<T> g) {
        this.generators.add(g);
        this.reset();
    }

    public boolean removeCombinationGenerator(CombinationGenerator<T> g) {
        boolean removed = this.generators.remove(g);
        this.reset();
        return removed;
    }

    @Override
    public boolean hasNext() {
        if (this.lookahead == this.UNKNOWN) {
            do {
                this.lookahead = this.getNextImpl();
            } while (this.lookahead == this.NEXT);
        }
        return this.lookahead != null;
    }

    @Override
    public List<List<T>> next() {
        List<List<T>> next;
        if (this.lookahead != this.UNKNOWN) {
            List<List<T>> result = this.lookahead;
            this.lookahead = this.UNKNOWN;
            return result;
        }
        while ((next = this.getNextImpl()) == this.NEXT) {
        }
        return next;
    }

    protected List<List<T>> getNextImpl() {
        while (!this.getCurrentGenerator().hasNext()) {
            if (this.isFirstGenerator()) {
                return null;
            }
            this.currentStack.pop();
            this.getCurrentGenerator().reset();
            this.setCurrentGenerator(this.getPreviousGenerator());
        }
        if (!this.currentStack.isEmpty()) {
            this.currentStack.pop();
        }
        this.currentStack.push((List)this.getCurrentGenerator().next());
        boolean validCombination = this.produceCombinationIfValid();
        while (!this.isLastGenerator() && validCombination) {
            this.setCurrentGenerator(this.getNextGenerator());
            this.currentStack.push((List)this.getCurrentGenerator().next());
            validCombination = this.produceCombinationIfValid();
        }
        return validCombination ? this.currentStack : this.NEXT;
    }

    private boolean produceCombinationIfValid() {
        boolean validCombination = this.isValidCombination();
        if (validCombination) {
            this.getCurrentGenerator().producedValidCombination();
        }
        return validCombination;
    }

    @Override
    public void reset() {
        for (CombinationGenerator<T> g : this.generators) {
            g.reset();
        }
        if (!this.generators.isEmpty()) {
            this.currentGeneratorIndex = 0;
        }
    }

    protected boolean isValidCombination() {
        for (Iterable iterable : this.currentStack) {
            if (iterable != null) continue;
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        try {
            return this.validator.isValid(this.currentStack);
        }
        catch (EolRuntimeException eolRuntimeException) {
            this.validator.getExceptionHandler().handleException((Exception)((Object)eolRuntimeException));
            return false;
        }
    }

    protected CombinationGenerator<T> getPreviousGenerator() {
        if (this.currentGeneratorIndex == 0) {
            return null;
        }
        return this.generators.get(this.currentGeneratorIndex - 1);
    }

    protected CombinationGenerator<T> getNextGenerator() {
        if (this.currentGeneratorIndex == this.generators.size() - 1) {
            return null;
        }
        return this.generators.get(this.currentGeneratorIndex + 1);
    }

    protected CombinationGenerator<T> getCurrentGenerator() {
        return this.generators.get(this.currentGeneratorIndex);
    }

    protected void setCurrentGenerator(CombinationGenerator<T> g) {
        this.currentGeneratorIndex = this.generators.indexOf(g);
    }

    protected boolean isFirstGenerator() {
        return this.getPreviousGenerator() == null;
    }

    protected boolean isLastGenerator() {
        return this.getNextGenerator() == null;
    }

    @Override
    public void producedValidCombination() {
    }
}

