/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.combinations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.common.function.ExceptionHandler;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.epl.combinations.DynamicListListener;

public abstract class DynamicList<T>
implements List<T> {
    private List<T> values;
    private boolean reset = true;
    private boolean resetable = false;
    private ExceptionHandler<EolRuntimeException> exceptionHandler;
    private ArrayList<DynamicListListener<T>> listeners = new ArrayList(2);

    protected abstract List<T> getValues() throws EolRuntimeException;

    final void check() {
        block4: {
            if (this.reset || this.values == null) {
                try {
                    this.values = this.getValues();
                    this.reset = false;
                    for (DynamicListListener<T> listener : this.listeners) {
                        listener.valuesChanged(this);
                    }
                }
                catch (EolRuntimeException ex) {
                    if (this.exceptionHandler == null) break block4;
                    this.exceptionHandler.handleException((Exception)((Object)ex));
                }
            }
        }
    }

    public void addListener(DynamicListListener<T> listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(DynamicListListener<T> listener) {
        return this.listeners.remove(listener);
    }

    public ExceptionHandler<EolRuntimeException> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler<EolRuntimeException> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void reset() {
        if (this.resetable) {
            this.reset = true;
        }
    }

    public boolean isResetable() {
        return this.resetable;
    }

    public void setResetable(boolean resetable) {
        this.resetable = resetable;
    }

    @Override
    public boolean add(T arg0) {
        this.check();
        return this.values.add(arg0);
    }

    @Override
    public void add(int arg0, T arg1) {
        this.check();
        this.values.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        this.check();
        return this.values.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        this.check();
        return this.values.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.check();
        this.values.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        this.check();
        return this.values.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        this.check();
        return this.values.containsAll(arg0);
    }

    @Override
    public T get(int arg0) {
        this.check();
        return this.values.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        this.check();
        return this.values.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        this.check();
        return this.values.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        this.check();
        return this.values.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        this.check();
        return this.values.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<T> listIterator() {
        this.check();
        return this.values.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        this.check();
        return this.values.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        this.check();
        return this.values.remove(arg0);
    }

    @Override
    public T remove(int arg0) {
        this.check();
        return this.values.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        this.check();
        return this.values.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        this.check();
        return this.values.retainAll(arg0);
    }

    @Override
    public T set(int arg0, T arg1) {
        this.check();
        return this.values.set(arg0, arg1);
    }

    @Override
    public int size() {
        this.check();
        return this.values.size();
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        this.check();
        return this.values.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        this.check();
        return this.values.toArray();
    }

    @Override
    public <A> A[] toArray(A[] arg0) {
        this.check();
        return this.values.toArray(arg0);
    }
}

