/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.combinations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;
import org.eclipse.epsilon.epl.combinations.CombinationGeneratorListener;
import org.eclipse.epsilon.epl.combinations.DynamicList;
import org.eclipse.epsilon.epl.combinations.ListCombinationGenerator;
import org.eclipse.epsilon.epl.dom.NoMatch;

public class DynamicListCombinationGenerator<T>
implements CombinationGenerator<T> {
    protected int n;
    protected List<T> list;
    protected ListCombinationGenerator<T> listCombinationGenerator;
    protected ArrayList<CombinationGeneratorListener<T>> listeners = new ArrayList(2);
    protected boolean producedValidCombination = false;
    protected State state = State.NORMAL;
    protected Boolean optional = null;

    public DynamicListCombinationGenerator(List<T> list, int n) {
        this.init(list, n);
    }

    protected void init(List<T> list, int n) {
        this.list = list;
        this.n = n;
        if (list instanceof DynamicList) {
            ((DynamicList)list).addListener((DynamicList<T> list_) -> this.createCombinationGenerator());
        } else {
            this.createCombinationGenerator();
        }
    }

    public void addListener(CombinationGeneratorListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CombinationGeneratorListener<T> listener) {
        this.listeners.remove(listener);
    }

    protected void createCombinationGenerator() {
        this.listCombinationGenerator = new ListCombinationGenerator<T>(this.list, this.n);
    }

    @Override
    public void reset() {
        if (this.listCombinationGenerator != null) {
            this.listCombinationGenerator.reset();
        }
        if (this.list instanceof DynamicList) {
            ((DynamicList)this.list).reset();
        }
        for (CombinationGeneratorListener<T> listener : this.listeners) {
            listener.reset();
        }
        this.producedValidCombination = false;
        this.state = State.NORMAL;
        this.optional = null;
    }

    @Override
    public boolean hasNext() {
        if (this.state != State.NORMAL && this.isOptional()) {
            if (this.state == State.CAN_RETURN_OPTIONAL) {
                return true;
            }
            if (this.state == State.HAS_RETURNED_OPTIONAL) {
                return false;
            }
        }
        this.nudgeList();
        boolean hasMore = this.listCombinationGenerator.hasNext();
        if (!hasMore && !this.producedValidCombination && this.isOptional()) {
            this.state = State.CAN_RETURN_OPTIONAL;
            hasMore = true;
        }
        return hasMore;
    }

    @Override
    public List<T> next() {
        if (this.state != State.NORMAL && this.isOptional()) {
            if (this.state == State.HAS_RETURNED_OPTIONAL) {
                return null;
            }
            if (this.state == State.CAN_RETURN_OPTIONAL) {
                ArrayList<NoMatch> optional = new ArrayList<NoMatch>(this.n);
                int i = 0;
                while (i < this.n) {
                    optional.add(NoMatch.INSTANCE);
                    ++i;
                }
                this.state = State.HAS_RETURNED_OPTIONAL;
                return optional;
            }
        }
        this.nudgeList();
        Object next = this.listCombinationGenerator.next();
        for (CombinationGeneratorListener<T> listener : this.listeners) {
            listener.generated((Collection<T>)next);
        }
        return next;
    }

    protected void nudgeList() {
        this.list.size();
    }

    protected boolean checkOptional() {
        return false;
    }

    @Override
    public void producedValidCombination() {
        this.producedValidCombination = true;
    }

    public final boolean isOptional() {
        if (this.optional == null) {
            this.optional = this.checkOptional();
        }
        return this.optional;
    }

    static enum State {
        NORMAL,
        CAN_RETURN_OPTIONAL,
        HAS_RETURNED_OPTIONAL;

    }
}

