/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.combinations;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epsilon.epl.combinations.CombinationGenerator;

public class ListCombinationGenerator<T>
implements CombinationGenerator<T> {
    private int[] a;
    private int n;
    private int r;
    private BigInteger remaining;
    private BigInteger total;
    protected List<T> list;
    protected boolean initialised = false;

    public void initialise() {
        if (!this.initialised) {
            this.n = this.list.size();
            this.a = new int[this.r];
            BigInteger nFact = ListCombinationGenerator.getFactorial(this.n);
            BigInteger rFact = ListCombinationGenerator.getFactorial(this.r);
            BigInteger nminusrFact = ListCombinationGenerator.getFactorial(this.n - this.r);
            this.total = nFact.divide(rFact.multiply(nminusrFact));
            this.initialised = true;
            this.reset();
        }
    }

    public ListCombinationGenerator(List<T> list, int r) {
        this.r = r;
        this.list = list;
    }

    @Override
    public void reset() {
        if (this.initialised) {
            int i = 0;
            while (i < this.a.length) {
                this.a[i] = i;
                ++i;
            }
            this.remaining = new BigInteger(this.total.toString());
        }
    }

    public BigInteger getRemaining() {
        this.initialise();
        return this.remaining;
    }

    @Override
    public boolean hasNext() {
        this.initialise();
        if (this.list.isEmpty() || this.r > this.list.size()) {
            return false;
        }
        return this.remaining.compareTo(BigInteger.ZERO) == 1;
    }

    public BigInteger getTotal() {
        this.initialise();
        return this.total;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        int i = n;
        while (i > 1) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
            --i;
        }
        return fact;
    }

    @Override
    public List<T> next() {
        int j;
        this.initialise();
        if (!this.hasNext()) {
            return null;
        }
        if (this.remaining.equals(this.total)) {
            this.remaining = this.remaining.subtract(BigInteger.ONE);
        } else {
            int i = this.r - 1;
            while (this.a[i] == this.n - this.r + i) {
                --i;
            }
            this.a[i] = this.a[i] + 1;
            j = i + 1;
            while (j < this.r) {
                this.a[j] = this.a[i] + j - i;
                ++j;
            }
            this.remaining = this.remaining.subtract(BigInteger.ONE);
        }
        ArrayList<T> next = new ArrayList<T>(this.a.length);
        int[] nArray = this.a;
        int n = this.a.length;
        int n2 = 0;
        while (n2 < n) {
            j = nArray[n2];
            next.add(this.list.get(j));
            ++n2;
        }
        return next;
    }

    @Override
    public void producedValidCombination() {
    }
}

