/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.dom;

import org.eclipse.epsilon.common.module.AbstractModuleElement;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;

public class Cardinality
extends AbstractModuleElement {
    public static final int UNBOUNDED = -1;
    protected int lowerBound;
    protected int upperBound;

    public Cardinality() {
    }

    public Cardinality(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        AST firstChild = cst.getFirstChild();
        int firstChildBound = Cardinality.getBound(firstChild.getText());
        if (cst.getChildCount() == 1) {
            this.lowerBound = 1;
            this.upperBound = firstChildBound;
        } else {
            this.lowerBound = firstChildBound;
            this.upperBound = Cardinality.getBound(firstChild.getNextSibling().getText());
        }
    }

    protected static int getBound(String text) {
        if ("*".equals(text)) {
            return -1;
        }
        return Integer.parseInt(text);
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public boolean isUnbounded() {
        return this.upperBound == -1;
    }

    public boolean isMany() {
        return !this.isOne();
    }

    public boolean isOne() {
        return this.upperBound == 1 && this.lowerBound == 1;
    }

    public boolean isInBounds(int n) {
        return n >= this.lowerBound && (this.upperBound == -1 || n <= this.upperBound);
    }
}

