/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.execute;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.epl.dom.Pattern;

public class PatternMatch {
    protected final Pattern pattern;
    protected Map<String, Object> roleBindings = new HashMap<String, Object>();

    public PatternMatch(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Map<String, Object> getRoleBindings() {
        return this.roleBindings;
    }

    public Object getRoleBinding(String name) {
        return this.getRoleBindings().get(name);
    }

    public void putRoleBinding(Variable variable) {
        this.roleBindings.put(variable.getName(), variable.getValue());
    }

    public String toString() {
        return "Pattern '" + (Object)((Object)this.pattern) + "':" + System.lineSeparator() + "\t" + this.roleBindings.entrySet().stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatternMatch)) {
            return false;
        }
        PatternMatch that = (PatternMatch)o;
        return Objects.equals((Object)this.pattern, (Object)that.pattern) && Objects.equals(this.roleBindings.keySet(), that.roleBindings.keySet());
    }
}

