/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.epl.execute.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.StringOperationContributor;
import org.eclipse.epsilon.eol.models.Model;
import org.eclipse.epsilon.epl.dom.Pattern;
import org.eclipse.epsilon.epl.dom.Role;
import org.eclipse.epsilon.epl.execute.PatternMatch;
import org.eclipse.epsilon.epl.execute.model.PatternMatchPropertyGetter;
import org.eclipse.epsilon.epl.execute.model.PatternMatchPropertySetter;

public class PatternMatchModel
extends Model {
    protected final Map<String, Collection<PatternMatch>> matchMap = new HashMap<String, Collection<PatternMatch>>();
    protected final Map<String, Set<Object>> componentMap = new HashMap<String, Set<Object>>();
    protected final Set<PatternMatch> matches = new HashSet<PatternMatch>();

    public PatternMatchModel() {
        this.setName("P");
        this.propertyGetter = new PatternMatchPropertyGetter();
        this.propertySetter = new PatternMatchPropertySetter();
    }

    public void dispose() {
        super.dispose();
        this.matches.clear();
        this.componentMap.values().forEach(Set::clear);
        this.componentMap.clear();
        this.matchMap.values().forEach(Collection::clear);
    }

    public void addMatches(Collection<PatternMatch> matches) {
        for (PatternMatch match : matches) {
            this.addMatch(match);
        }
    }

    public void addMatch(PatternMatch match) {
        String patternName = match.getPattern().getName();
        Collection<PatternMatch> matchMapMatches = this.matchMap.get(patternName);
        matchMapMatches.add(match);
        this.matches.add(match);
        StringOperationContributor stringOps = new StringOperationContributor();
        for (String componentName : match.getRoleBindings().keySet()) {
            stringOps.setTarget((Object)componentName);
            Set<Object> values = this.componentMap.get(String.valueOf(patternName) + stringOps.firstToUpperCase());
            if (values == null) continue;
            values.add(match.getRoleBindings().get(componentName));
        }
    }

    public void setPatterns(Collection<Pattern> patterns) {
        StringOperationContributor stringOps = new StringOperationContributor();
        for (Pattern pattern : patterns) {
            String patternName = pattern.getName();
            this.matchMap.put(patternName, new ArrayList());
            for (Role role : pattern.getRoles()) {
                if (role.isNegative()) continue;
                for (String roleName : role.getNames()) {
                    stringOps.setTarget((Object)roleName);
                    String componentName = String.valueOf(patternName) + stringOps.firstToUpperCase();
                    this.componentMap.put(componentName, new HashSet());
                }
            }
        }
    }

    public void load() throws EolModelLoadingException {
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return null;
    }

    public Collection<?> allContents() {
        return this.getMatches();
    }

    public Set<PatternMatch> getMatches() {
        return this.matches;
    }

    public Collection<?> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        return this.matchMap.containsKey(type) ? this.matchMap.get(type) : (Collection)this.componentMap.get(type);
    }

    public Collection<?> getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        return this.getAllOfType(type);
    }

    public Object getTypeOf(Object instance) {
        assert (instance instanceof PatternMatch);
        return PatternMatch.class;
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof PatternMatch) {
            return ((PatternMatch)instance).getPattern().getName();
        }
        return null;
    }

    public Object createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        throw new EolNotInstantiableModelElementTypeException(this.name, type);
    }

    public Object getElementById(String id) {
        return null;
    }

    public String getElementId(Object instance) {
        return null;
    }

    public void setElementId(Object instance, String newId) {
    }

    public void deleteElement(Object instance) throws EolRuntimeException {
    }

    public boolean owns(Object instance) {
        return this.matches.contains(instance);
    }

    public boolean isInstantiable(String type) {
        return false;
    }

    public boolean isModelElement(Object instance) {
        return this.owns(instance);
    }

    public boolean hasType(String type) {
        return this.matchMap.containsKey(type) || this.componentMap.containsKey(type);
    }

    public boolean store(String location) {
        return false;
    }

    public boolean store() {
        return false;
    }

    public IPropertyGetter getPropertyGetter() {
        return this.propertyGetter;
    }

    public IPropertySetter getPropertySetter() {
        return this.propertySetter;
    }

    public String toString() {
        return this.matches.toString();
    }
}

