/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.IErlModule;
import org.eclipse.epsilon.erl.dom.ExtensibleNamedRule;
import org.eclipse.epsilon.erl.dom.NamedRuleList;
import org.eclipse.epsilon.erl.dom.NamedStatementBlockRule;
import org.eclipse.epsilon.erl.dom.Post;
import org.eclipse.epsilon.erl.dom.Pre;
import org.eclipse.epsilon.erl.exceptions.ErlCircularRuleInheritanceException;
import org.eclipse.epsilon.erl.exceptions.ErlRuleNotFoundException;
import org.eclipse.epsilon.erl.execute.context.ErlContext;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.erl.parse.ErlLexer;
import org.eclipse.epsilon.erl.parse.ErlParser;

public class ErlModule
extends EolModule
implements IErlModule {
    protected NamedRuleList<Pre> pre;
    protected NamedRuleList<Pre> declaredPre = new NamedRuleList();
    protected NamedRuleList<Post> post;
    protected NamedRuleList<Post> declaredPost = new NamedRuleList();

    public ErlModule() {
        this(null);
    }

    public ErlModule(IErlContext context) {
        super((IEolContext)(context != null ? context : new ErlContext()));
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        List preBlockASTs = AstUtil.getChildren((AST)cst, (int[])new int[]{83});
        List postBlockASTs = AstUtil.getChildren((AST)cst, (int[])new int[]{84});
        this.declaredPre.ensureCapacity(preBlockASTs.size());
        for (AST preBlockAst : preBlockASTs) {
            this.declaredPre.add((Pre)module.createAst(preBlockAst, (ModuleElement)this));
        }
        this.declaredPost.ensureCapacity(preBlockASTs.size());
        for (AST postBlockAst : postBlockASTs) {
            this.declaredPost.add((Post)module.createAst(postBlockAst, (ModuleElement)this));
        }
    }

    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new ErlLexer((CharStream)inputStream);
    }

    public EpsilonParser createParser(TokenStream tokenStream) {
        return new ErlParser(tokenStream);
    }

    public String getMainRule() {
        return "erlModule";
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        switch (cst.getType()) {
            case 83: {
                return new Pre();
            }
            case 84: {
                return new Post();
            }
        }
        return super.adapt(cst, parentAst);
    }

    public HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap importConfiguration = super.getImportConfiguration();
        importConfiguration.put("erl", ErlModule.class);
        return importConfiguration;
    }

    @Override
    public List<Post> getPost() {
        if (this.post == null) {
            this.post = new NamedRuleList();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IErlModule)) continue;
                IErlModule module = (IErlModule)import_.getModule();
                this.post.addAll((Collection<Post>)module.getPost());
            }
            this.post.addAll((Collection<Post>)this.declaredPost);
        }
        return this.post;
    }

    @Override
    public List<Pre> getPre() {
        if (this.pre == null) {
            this.pre = new NamedRuleList();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IErlModule)) continue;
                IErlModule module = (IErlModule)import_.getModule();
                this.pre.addAll((Collection<Pre>)module.getPre());
            }
            this.pre.addAll((Collection<Pre>)this.declaredPre);
        }
        return this.pre;
    }

    @Override
    public List<Post> getDeclaredPost() {
        return this.declaredPost;
    }

    @Override
    public List<Pre> getDeclaredPre() {
        return this.declaredPre;
    }

    public void prepareExecution() throws EolRuntimeException {
        this.prepareContext();
        this.execute(this.getPre(), this.getContext());
    }

    public void postExecution() throws EolRuntimeException {
        this.execute(this.getPost(), this.getContext());
    }

    protected void execute(List<? extends NamedStatementBlockRule> namedRules) throws EolRuntimeException {
        this.execute(namedRules, this.getContext());
    }

    protected void execute(List<? extends NamedStatementBlockRule> namedRules, IEolContext context) throws EolRuntimeException {
        ExecutorFactory executorFactory = context.getExecutorFactory();
        for (NamedStatementBlockRule namedStatementBlockRule : namedRules) {
            executorFactory.execute((ModuleElement)namedStatementBlockRule, context);
        }
    }

    public Object executeImpl() throws EolRuntimeException {
        this.prepareExecution();
        Object result = this.processRules();
        this.postExecution();
        return result;
    }

    protected Object processRules() throws EolRuntimeException {
        return null;
    }

    public List<ParseProblem> calculateSuperRules(List<? extends ExtensibleNamedRule> allRules) {
        ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
        for (ExtensibleNamedRule extensibleNamedRule : allRules) {
            try {
                extensibleNamedRule.calculateSuperRules(allRules);
            }
            catch (ErlCircularRuleInheritanceException | ErlRuleNotFoundException e) {
                ParseProblem problem = new ParseProblem();
                problem.setLine(extensibleNamedRule.getRegion().getStart().getLine());
                problem.setReason(e.getReason());
                parseProblems.add(problem);
            }
        }
        return parseProblems;
    }

    @Override
    public IErlContext getContext() {
        return (IErlContext)super.getContext();
    }
}

