/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.erl.dom.NamedRule;
import org.eclipse.epsilon.erl.exceptions.ErlCircularRuleInheritanceException;
import org.eclipse.epsilon.erl.exceptions.ErlRuleNotFoundException;

public abstract class ExtensibleNamedRule
extends NamedRule {
    protected List<NameExpression> superRulesIdentifiers = new ArrayList<NameExpression>();
    protected List<ExtensibleNamedRule> superRules = new ArrayList<ExtensibleNamedRule>();
    protected List<ExtensibleNamedRule> allSuperRules = new ArrayList<ExtensibleNamedRule>();
    protected Boolean isGreedy;
    protected Boolean isAbstract;
    protected Boolean isLazy;
    protected Boolean isParallel;
    protected Map<Parameter, Collection<?>> ofTypeCache = new HashMap();
    protected Map<Parameter, Collection<?>> ofKindCache = new HashMap();

    public Collection<?> getAllOfKind(Parameter parameter, IEolContext context) throws EolRuntimeException {
        return this.getAllInstances(parameter, context, false);
    }

    public Collection<?> getAllOfType(Parameter parameter, IEolContext context) throws EolRuntimeException {
        return this.getAllInstances(parameter, context, true);
    }

    public Collection<?> getAllInstances(Parameter parameter, IEolContext context, boolean ofTypeOnly) throws EolRuntimeException {
        Map<Parameter, Collection<?>> cache = ofTypeOnly ? this.ofTypeCache : this.ofKindCache;
        Collection instances = cache.get(parameter);
        if (instances == null) {
            try {
                EolModelElementType parameterType = (EolModelElementType)parameter.getType(context);
                instances = ofTypeOnly ? parameterType.getAllOfType() : parameterType.getAllOfKind();
                cache.put(parameter, instances);
            }
            catch (EolModelElementTypeNotFoundException ex) {
                ex.setAst((ModuleElement)parameter.getTypeExpression());
                throw ex;
            }
            catch (EolModelNotFoundException ex) {
                ex.setAst((ModuleElement)parameter.getTypeExpression());
                throw ex;
            }
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParallel(IEolContext context) throws EolRuntimeException {
        if (this.isParallel == null) {
            ExtensibleNamedRule extensibleNamedRule = this;
            synchronized (extensibleNamedRule) {
                if (this.isParallel == null) {
                    this.isParallel = this.getBooleanAnnotationValue("parallel", context);
                }
            }
        }
        return this.isParallel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGreedy(IEolContext context) throws EolRuntimeException {
        if (this.isGreedy == null) {
            ExtensibleNamedRule extensibleNamedRule = this;
            synchronized (extensibleNamedRule) {
                if (this.isGreedy == null) {
                    this.isGreedy = this.getBooleanAnnotationValue("greedy", context);
                }
            }
        }
        return this.isGreedy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAbstract(IEolContext context) throws EolRuntimeException {
        if (this.isAbstract == null) {
            ExtensibleNamedRule extensibleNamedRule = this;
            synchronized (extensibleNamedRule) {
                if (this.isAbstract == null) {
                    this.isAbstract = this.getBooleanAnnotationValue("abstract", context);
                }
            }
        }
        return this.isAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLazy(IEolContext context) throws EolRuntimeException {
        if (this.isLazy == null) {
            ExtensibleNamedRule extensibleNamedRule = this;
            synchronized (extensibleNamedRule) {
                if (this.isLazy == null) {
                    this.isLazy = this.getBooleanAnnotationValue("lazy", context);
                }
            }
        }
        return this.isLazy;
    }

    public void calculateSuperRules(List<? extends ExtensibleNamedRule> allRules) throws ErlRuleNotFoundException, ErlCircularRuleInheritanceException {
        this.superRules = new ArrayList<ExtensibleNamedRule>();
        this.calculateSuperRules(this, allRules, this.superRules, false);
        this.allSuperRules = new ArrayList<ExtensibleNamedRule>();
        this.calculateSuperRules(this, allRules, this.allSuperRules, true);
    }

    protected void calculateSuperRules(ExtensibleNamedRule rule, List<? extends ExtensibleNamedRule> allRules, List<ExtensibleNamedRule> collectedRules, boolean recursive) throws ErlRuleNotFoundException, ErlCircularRuleInheritanceException {
        for (NameExpression superRuleAst : rule.superRulesIdentifiers) {
            String superRuleName = superRuleAst.getName();
            ExtensibleNamedRule superRule = (ExtensibleNamedRule)this.getRuleByName(allRules, superRuleName);
            if (superRule != null) {
                if (this.getRuleByName(collectedRules, superRule.getName()) != null) {
                    throw new ErlCircularRuleInheritanceException(superRule);
                }
                collectedRules.add(superRule);
                if (!recursive) continue;
                this.calculateSuperRules(superRule, allRules, collectedRules, true);
                continue;
            }
            throw new ErlRuleNotFoundException(superRuleAst);
        }
    }

    protected NamedRule getRuleByName(List<? extends NamedRule> rules, String name) {
        for (NamedRule namedRule : rules) {
            if (!namedRule.getName().equals(name)) continue;
            return namedRule;
        }
        return null;
    }

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        AST superRulesAst = this.getSuperRulesAst(cst);
        if (superRulesAst != null) {
            AST superRuleAst = superRulesAst.getFirstChild();
            while (superRuleAst != null) {
                this.superRulesIdentifiers.add((NameExpression)module.createAst(superRuleAst, (ModuleElement)this));
                superRuleAst = superRuleAst.getNextSibling();
            }
        }
    }

    public abstract AST getSuperRulesAst(AST var1);

    public List<ExtensibleNamedRule> getAllSuperRules() {
        return this.allSuperRules;
    }

    public List<ExtensibleNamedRule> getSuperRules() {
        return this.superRules;
    }
}

