/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.execute.context.concurrent;

import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.concurrent.EolContextParallel;
import org.eclipse.epsilon.erl.IErlModule;
import org.eclipse.epsilon.erl.IErlModuleAtomBatches;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;
import org.eclipse.epsilon.erl.execute.context.ErlContext;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.erl.execute.context.concurrent.IErlContextParallel;
import org.eclipse.epsilon.erl.execute.data.JobBatch;
import org.eclipse.epsilon.erl.execute.data.RuleAtom;

public class ErlContextParallel
extends EolContextParallel
implements IErlContextParallel {
    public ErlContextParallel() {
        this(0);
    }

    public ErlContextParallel(int parallelism) {
        super(parallelism);
        this.setExecutorFactory(new RuleExecutorFactory());
    }

    protected ErlContextParallel(IEolContext other) {
        super(other);
        this.setExecutorFactory(this.executorFactory);
    }

    protected ExecutorFactory createThreadLocalExecutorFactory() {
        return new RuleExecutorFactory(this.executorFactory);
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        super.setProfilingEnabled(profilingEnabled);
        this.getExecutorFactory().setProfilingEnabled(profilingEnabled);
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        super.setExecutorFactory((ExecutorFactory)(executorFactory instanceof RuleExecutorFactory ? executorFactory : new RuleExecutorFactory(executorFactory)));
    }

    @Override
    public RuleExecutorFactory getExecutorFactory() {
        return (RuleExecutorFactory)super.getExecutorFactory();
    }

    protected IErlContext createShadowThreadLocalContext() {
        return new ErlContext(this);
    }

    public IErlContext getShadow() {
        return (IErlContext)super.getShadow();
    }

    @Override
    public IErlModule getModule() {
        return (IErlModule)super.getModule();
    }

    public Object executeJob(Object job) throws EolRuntimeException {
        IErlModule module;
        if (job instanceof RuleAtom) {
            return ((RuleAtom)job).execute(this.getShadow());
        }
        if (job instanceof JobBatch && (module = this.getModule()) instanceof IErlModuleAtomBatches) {
            List allJobs = ((IErlModuleAtomBatches)module).getAllJobs();
            assert (allJobs.size() >= ((JobBatch)job).to);
            return this.executeJob(((JobBatch)job).split(allJobs));
        }
        return super.executeJob(job);
    }
}

