/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.erl.execute.data;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.erl.execute.context.IErlContext;

public abstract class RuleAtom<T extends IExecutableModuleElementParameter> {
    public final T rule;
    public final Object element;
    protected int hashCode;

    public RuleAtom(T construct, Object modelElement) {
        this.rule = construct;
        this.element = modelElement;
        this.hashCode = Objects.hash(this.rule, this.element);
    }

    public Object execute(IErlContext context) throws EolRuntimeException {
        return context.getExecutorFactory().execute((IExecutableModuleElementParameter)this.rule, context, this.element);
    }

    public Map.Entry<T, Object> asEntry() {
        return new AbstractMap.SimpleEntry<T, Object>(this.rule, this.element);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [unit=" + this.rule + ", element=" + this.element + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleAtom)) {
            return false;
        }
        RuleAtom other = (RuleAtom)obj;
        return Objects.equals(this.element, other.element) && Objects.equals(this.rule, other.rule);
    }
}

