/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl;

import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.dom.NamedRule;
import org.eclipse.epsilon.erl.dom.NamedRuleList;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.etl.IEtlModule;
import org.eclipse.epsilon.etl.debug.EtlDebugger;
import org.eclipse.epsilon.etl.dom.EquivalentAssignmentStatement;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.execute.context.EtlContext;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.execute.operations.EtlOperationFactory;
import org.eclipse.epsilon.etl.parse.EtlLexer;
import org.eclipse.epsilon.etl.parse.EtlParser;
import org.eclipse.epsilon.etl.strategy.AbstractTransformationStrategy;
import org.eclipse.epsilon.etl.strategy.DefaultTransformationStrategy;
import org.eclipse.epsilon.etl.strategy.FastTransformationStrategy;
import org.eclipse.epsilon.etl.strategy.ITransformationStrategy;

public class EtlModule
extends ErlModule
implements IEtlModule {
    protected NamedRuleList<TransformationRule> declaredTransformationRules = new NamedRuleList();
    protected NamedRuleList<TransformationRule> transformationRules;

    public EtlModule() {
        this(null);
    }

    public EtlModule(IEtlContext context) {
        super((IErlContext)(context != null ? context : new EtlContext()));
    }

    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new EtlLexer((CharStream)inputStream);
    }

    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EtlParser(tokenStream);
    }

    public String getMainRule() {
        return "etlModule";
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        if (cst.getType() == 87) {
            return new TransformationRule();
        }
        if (cst.getType() == 86) {
            return new ExecutableBlock(Boolean.class);
        }
        if (cst.getType() == 67 && cst.getParent() != null && cst.getParent().getType() == 87) {
            return new ExecutableBlock(Void.class);
        }
        if (cst.getType() == 31) {
            return new EquivalentAssignmentStatement();
        }
        return super.adapt(cst, parentAst);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        List transformationChildrenAsts = AstUtil.getChildren((AST)cst, (int[])new int[]{87});
        this.declaredTransformationRules.ensureCapacity(transformationChildrenAsts.size());
        for (AST transformationRuleAst : transformationChildrenAsts) {
            this.declaredTransformationRules.add((NamedRule)((TransformationRule)module.createAst(transformationRuleAst, (ModuleElement)this)));
        }
        this.getParseProblems().addAll(this.calculateSuperRules(this.getTransformationRules()));
    }

    protected void prepareContext() throws EolRuntimeException {
        super.prepareContext();
        IEtlContext context = this.getContext();
        context.getFrameStack().put(new Variable[]{Variable.createReadOnlyVariable((String)"transTrace", (Object)context.getTransformationTrace()), Variable.createReadOnlyVariable((String)"context", (Object)context), Variable.createReadOnlyVariable((String)"module", (Object)this)});
        context.setOperationFactory(new EtlOperationFactory());
        if (context.getTransformationStrategy() == null) {
            AbstractTransformationStrategy transformStrat = this.hasLazyRules() ? new DefaultTransformationStrategy() : new FastTransformationStrategy();
            context.setTransformationStrategy(transformStrat);
        }
    }

    protected Object processRules() throws EolRuntimeException {
        IEtlContext context = this.getContext();
        ITransformationStrategy transformStrat = context.getTransformationStrategy();
        if (transformStrat != null) {
            transformStrat.transformModels(context);
        }
        return context.getTransformationTrace();
    }

    public HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap importConfiguration = super.getImportConfiguration();
        importConfiguration.put("etl", EtlModule.class);
        return importConfiguration;
    }

    @Override
    public IEtlContext getContext() {
        return (IEtlContext)super.getContext();
    }

    @Override
    public List<TransformationRule> getDeclaredTransformationRules() {
        return this.declaredTransformationRules;
    }

    protected boolean hasLazyRules() throws EolRuntimeException {
        IEtlContext context = this.getContext();
        for (TransformationRule rule : this.getTransformationRules()) {
            if (!rule.isLazy((IEolContext)context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TransformationRule> getTransformationRules() {
        if (this.transformationRules == null) {
            this.transformationRules = new NamedRuleList();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEtlModule)) continue;
                IEtlModule module = (IEtlModule)import_.getModule();
                this.transformationRules.addAll(module.getTransformationRules());
            }
            this.transformationRules.addAll(this.declaredTransformationRules);
        }
        return this.transformationRules;
    }

    public EolDebugger createDebugger() {
        return new EtlDebugger();
    }
}

