/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.strategy.AbstractTransformationStrategy;
import org.eclipse.epsilon.etl.trace.Transformation;
import org.eclipse.epsilon.etl.trace.TransformationTrace;

public class FastTransformationStrategy
extends AbstractTransformationStrategy {
    protected Map<Object, Collection<Object>> flatTrace = new HashMap<Object, Collection<Object>>();
    protected Map<Object, Collection<Transformation>> pendingTransformations = new HashMap<Object, Collection<Transformation>>();

    @Override
    public Collection<?> transform(Object source, IEtlContext context, List<String> rules) throws EolRuntimeException {
        throw new UnsupportedOperationException("FastTransformationStrategy cannot transform single objects. Please use DefaultTransformationStrategy instead.");
    }

    public Collection<?> getEquivalents(Object source, IErlContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        if (this.pendingTransformations.containsKey(source)) {
            Collection<Transformation> transformations = this.pendingTransformations.remove(source);
            this.executeTransformations(transformations, context);
        }
        if (rules == null || rules.isEmpty()) {
            return this.flatTrace.get(source);
        }
        ArrayList<Object> equivalents = new ArrayList<Object>();
        for (Transformation transformation : context.getTransformationTrace().getTransformations(source)) {
            if (!rules.contains(transformation.getRule().getName())) continue;
            equivalents.addAll(transformation.getTargets());
        }
        return equivalents;
    }

    @Override
    public void transformModels(IEtlContext context) throws EolRuntimeException {
        TransformationTrace transTrace = context.getTransformationTrace();
        for (TransformationRule transformRule : context.getModule().getTransformationRules()) {
            if (transformRule.isLazy((IEolContext)context) || transformRule.isAbstract((IEolContext)context)) continue;
            Collection sources = transformRule.getAllInstances(transformRule.getSourceParameter(), (IEolContext)context, !transformRule.isGreedy((IEolContext)context));
            for (Object instance : sources) {
                if (this.getExcluded().contains(instance) || !transformRule.appliesTo(instance, context, false, false)) continue;
                List targets = CollectionUtil.createDefaultList();
                for (Parameter target : transformRule.getTargetParameters()) {
                    targets.add(target.getType((IEolContext)context).createInstance());
                }
                transTrace.add(instance, targets, transformRule);
            }
        }
        for (Transformation transformation : transTrace.getTransformations()) {
            Object source = transformation.getSource();
            if (this.flatTrace.containsKey(transformation.getSource())) {
                if (transformation.getRule().isPrimary(context)) {
                    this.flatTrace.put(source, EolCollectionType.join(transformation.getTargets(), this.flatTrace.get(source)));
                } else {
                    this.flatTrace.get(source).addAll(transformation.getTargets());
                }
            } else {
                this.flatTrace.put(source, EolCollectionType.clone(transformation.getTargets()));
            }
            Collection<Transformation> pending = this.pendingTransformations.get(source);
            if (pending != null) {
                pending.add(transformation);
                continue;
            }
            ArrayList<Transformation> transformations = new ArrayList<Transformation>(1);
            transformations.add(transformation);
            this.pendingTransformations.put(source, transformations);
        }
        this.executeTransformations(transTrace.getTransformations(), context);
    }

    protected void executeTransformations(Collection<Transformation> transformations, IEtlContext context) throws EolRuntimeException {
        for (Transformation transformation : transformations) {
            Object source;
            TransformationRule rule = transformation.getRule();
            if (rule.hasTransformed(source = transformation.getSource())) continue;
            rule.transform(source, transformation.getTargets(), context);
        }
    }
}

