/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.strategy;

import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.erl.strategy.IEquivalentProvider;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;

public interface ITransformationStrategy
extends IEquivalentProvider {
    public Collection<?> transform(Object var1, IEtlContext var2, List<String> var3) throws EolRuntimeException;

    public void transformModels(IEtlContext var1) throws EolRuntimeException;

    public void setEquivalentProvider(IEquivalentProvider var1);

    public boolean canTransform(Object var1);

    default public IEquivalentProvider getEquivalentProvider() {
        return this;
    }

    default public Object getEquivalent(Object source, IErlContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        Collection equivalents = this.getEquivalents(source, context, rules);
        if (equivalents != null && !equivalents.isEmpty()) {
            return CollectionUtil.getFirst((Iterable)equivalents);
        }
        return null;
    }

    default public Collection<?> getEquivalent(Collection<?> collection, IErlContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        return CollectionUtil.flatten(this.getEquivalents(collection, context, rules));
    }

    default public Collection<?> getEquivalents(Collection<?> collection, IErlContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        List equivalents = CollectionUtil.createDefaultList();
        for (Object item : collection) {
            Collection equivalent = this.getEquivalents(item, context, rules);
            if (equivalent == null || equivalents.contains(equivalent)) continue;
            equivalents.add(equivalent);
        }
        return equivalents;
    }
}

