/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.trace;

import com.google.common.collect.Iterators;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.trace.Transformation;

public class TransformationTrace {
    private final Table<Object, TransformationRule, List<Transformation>> transformations;
    private final boolean isConcurrent;

    public TransformationTrace() {
        this(false);
    }

    public TransformationTrace(boolean concurrent) {
        this.isConcurrent = concurrent;
        this.transformations = Tables.newCustomTable(this.createIdentityMap(), this::createIdentityMap);
    }

    private <K, V> Map<K, V> createIdentityMap() {
        return this.isConcurrent ? Collections.synchronizedMap(new LinkedHashMap()) : new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T syncOn(Object syncTarget, Supplier<T> r) {
        if (this.isConcurrent) {
            Object object = syncTarget;
            synchronized (object) {
                return r.get();
            }
        }
        return r.get();
    }

    public void add(Object source, Collection<Object> targets, TransformationRule rule) {
        Transformation transformation = new Transformation(source, targets);
        transformation.setRule(rule);
        List sourceRuleTransformations = this.syncOn(this.transformations, () -> {
            ArrayList l = (ArrayList)this.transformations.get(source, (Object)rule);
            if (l == null) {
                l = new ArrayList();
                this.transformations.put(source, (Object)rule, l);
            }
            return l;
        });
        this.syncOn(sourceRuleTransformations, () -> sourceRuleTransformations.add(transformation));
    }

    public Collection<Transformation> getTransformations() {
        return new AbstractCollection<Transformation>(){

            @Override
            public Iterator<Transformation> iterator() {
                Iterator itCells = TransformationTrace.this.transformations.cellSet().iterator();
                Iterator itLists = Iterators.transform(itCells, cell -> (List)cell.getValue());
                return new TransformationListIterator(itLists);
            }

            @Override
            public int size() {
                int size = 0;
                for (Table.Cell cell : TransformationTrace.this.transformations.cellSet()) {
                    size += ((List)cell.getValue()).size();
                }
                return size;
            }
        };
    }

    public Collection<Transformation> getTransformations(final Object source) {
        return new AbstractCollection<Transformation>(){

            @Override
            public Iterator<Transformation> iterator() {
                return new TransformationListIterator(TransformationTrace.this.transformations.row(source).values().iterator());
            }

            @Override
            public int size() {
                int size = 0;
                for (List txList : TransformationTrace.this.transformations.row(source).values()) {
                    size += txList.size();
                }
                return size;
            }
        };
    }

    public Collection<?> getTransformationTargets(Object source, TransformationRule rule) {
        List txList = (List)this.transformations.get(source, (Object)rule);
        return txList == null ? Collections.emptyList() : new TransformationTargetsCollection(txList);
    }

    @Deprecated
    public Collection<?> getTransformationTargets(Object source, String rule) {
        Map sourceMap = this.transformations.row(source);
        if (sourceMap == null) {
            return Collections.emptyList();
        }
        for (Map.Entry entry : sourceMap.entrySet()) {
            if (!((TransformationRule)((Object)entry.getKey())).getName().equals(rule)) continue;
            return new TransformationTargetsCollection((List)entry.getValue());
        }
        return Collections.emptyList();
    }

    public boolean containsTransformedBy(TransformationRule rule) {
        return this.transformations.columnKeySet().contains((Object)rule);
    }

    private class TransformationListIterator
    implements Iterator<Transformation> {
        private final Iterator<List<Transformation>> itLists;
        private Iterator<Transformation> itTransformation;
        private Transformation next;

        private TransformationListIterator(Iterator<List<Transformation>> itLists) {
            this.itLists = itLists;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (this.itTransformation == null || !this.itTransformation.hasNext()) {
                    if (this.itLists.hasNext()) {
                        this.itTransformation = this.itLists.next().iterator();
                        continue;
                    }
                    this.itTransformation = null;
                    return false;
                }
                this.next = this.itTransformation.next();
            }
            return this.next != null;
        }

        @Override
        public Transformation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Transformation ret = this.next;
            this.next = null;
            return ret;
        }
    }

    private class TransformationTargetsCollection
    extends AbstractCollection<Object> {
        private final List<Transformation> txList;

        public TransformationTargetsCollection(List<Transformation> txList) {
            this.txList = txList;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                final Iterator<Transformation> itTransformation;
                Iterator<Object> itTarget;
                Object next;
                {
                    this.itTransformation = TransformationTargetsCollection.this.txList.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        while (this.itTarget == null || !this.itTarget.hasNext()) {
                            if (this.itTransformation.hasNext()) {
                                this.itTarget = this.itTransformation.next().getTargets().iterator();
                                continue;
                            }
                            this.itTarget = null;
                            return false;
                        }
                        this.next = this.itTarget.next();
                    }
                    return this.next != null;
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object ret = this.next;
                    this.next = null;
                    return ret;
                }
            };
        }

        @Override
        public int size() {
            return this.txList.size();
        }
    }
}

