/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock;

import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.flock.IFlockModule;
import org.eclipse.epsilon.flock.debug.FlockDebugger;
import org.eclipse.epsilon.flock.execute.FlockResult;
import org.eclipse.epsilon.flock.execute.context.FlockContext;
import org.eclipse.epsilon.flock.execute.context.IFlockContext;
import org.eclipse.epsilon.flock.model.domain.EquivalentAssignmentStatement;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.rules.MigrateRule;
import org.eclipse.epsilon.flock.model.domain.typemappings.Deletion;
import org.eclipse.epsilon.flock.model.domain.typemappings.PackageDeletion;
import org.eclipse.epsilon.flock.model.domain.typemappings.PackageRetyping;
import org.eclipse.epsilon.flock.model.domain.typemappings.Retyping;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;
import org.eclipse.epsilon.flock.parse.FlockLexer;
import org.eclipse.epsilon.flock.parse.FlockParser;

public class FlockModule
extends ErlModule
implements IFlockModule {
    protected MigrationStrategy strategy;

    public FlockModule() {
        this(null);
    }

    public FlockModule(IFlockContext context) {
        super((IErlContext)(context != null ? context : new FlockContext()));
    }

    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new FlockLexer((CharStream)inputStream);
    }

    public EpsilonParser createParser(TokenStream tokenStream) {
        return new FlockParser(tokenStream);
    }

    public String getMainRule() {
        return "flockModule";
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        switch (cst.getType()) {
            case 86: {
                return new ExecutableBlock(Boolean.class);
            }
            case 57: {
                return new Deletion();
            }
            case 88: {
                return new Retyping();
            }
            case 91: {
                return new MigrateRule();
            }
            case 89: {
                return new PackageRetyping();
            }
            case 90: {
                return new PackageDeletion();
            }
            case 31: {
                return new EquivalentAssignmentStatement();
            }
            case 67: {
                if (cst.getParent() == null || cst.getParent().getType() != 91) break;
                return new ExecutableBlock(Void.class);
            }
        }
        return super.adapt(cst, parentAst);
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.strategy = this.createMigrationStrategy();
        for (AST childAst : cst.getChildren()) {
            ModuleElement moduleElement = module.createAst(childAst, (ModuleElement)module);
            if (moduleElement instanceof MigrateRule) {
                this.strategy.addRule((MigrateRule)moduleElement);
                continue;
            }
            if (!(moduleElement instanceof Retyping) && !(moduleElement instanceof PackageRetyping) && !(moduleElement instanceof Deletion) && !(moduleElement instanceof PackageDeletion)) continue;
            this.strategy.addTypeMappingConstruct((TypeMappingConstruct)moduleElement);
        }
    }

    protected MigrationStrategy createMigrationStrategy() {
        return new MigrationStrategy(new ClassifierTypedConstruct[0]);
    }

    public FlockResult execute() throws EolRuntimeException {
        return (FlockResult)super.execute();
    }

    @Override
    public FlockResult execute(IModel original, IModel migrated) throws EolRuntimeException {
        IFlockContext context = this.getContext();
        context.setOriginalModel(original);
        context.setMigratedModel(migrated);
        return this.execute();
    }

    protected FlockResult processRules() throws EolRuntimeException {
        return this.getContext().execute(this.strategy);
    }

    @Override
    public MigrationStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public IFlockContext getContext() {
        return (IFlockContext)super.getContext();
    }

    public EolDebugger createDebugger() {
        return new FlockDebugger();
    }
}

