/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.context;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.flock.context.TypeMappingContext;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;

public class EquivalenceEstablishmentContext {
    private final Model originalModel;
    private final Model migratedModel;
    private final IEolContext context;
    private final FlockExecution execution;
    private final EquivalentFactory factory;

    public EquivalenceEstablishmentContext(Model originalModel, Model migratedModel, IEolContext context, FlockExecution execution) {
        this.originalModel = originalModel;
        this.migratedModel = migratedModel;
        this.context = context;
        this.execution = execution;
        this.factory = new EquivalentFactory();
    }

    public Collection<TypeMappingContext> getTypeMappingContexts() {
        LinkedList<TypeMappingContext> contexts = new LinkedList<TypeMappingContext>();
        for (ModelElement original : this.originalModel.directContents()) {
            contexts.add(new TypeMappingContext(original, this.context, this.execution, this.factory));
        }
        return contexts;
    }

    public class EquivalentFactory {
        public ModelElement createModelElementInMigratedModel(String type) throws FlockRuntimeException {
            try {
                return EquivalenceEstablishmentContext.this.migratedModel.createInstance(type);
            }
            catch (EolRuntimeException e) {
                throw new FlockRuntimeException("Could not create in the migrated model a model element of type: " + type, e);
            }
        }

        public boolean typeConformsToEvolvedMetamodel(String type) {
            return EquivalenceEstablishmentContext.this.migratedModel.isInstantiable(type);
        }
    }
}

