/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.context;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.flock.context.GuardedConstructContext;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;

public class MigrateRuleContext {
    private final Equivalence equivalence;
    private final IEolContext context;
    private final FlockExecution execution;
    private final Map<ClassifierTypedConstruct, Boolean> applicabilityCache = new HashMap<ClassifierTypedConstruct, Boolean>();

    public MigrateRuleContext(Equivalence equivalence, IEolContext context, FlockExecution execution) {
        this.equivalence = equivalence;
        this.context = context;
        this.execution = execution;
    }

    public boolean isEligibleFor(ClassifierTypedConstruct guardedConstruct) throws EolRuntimeException {
        boolean applicability;
        if (this.applicabilityCache.containsKey((Object)guardedConstruct)) {
            applicability = this.applicabilityCache.get((Object)guardedConstruct);
        } else {
            applicability = guardedConstruct.appliesIn(this.getOriginal());
            this.applicabilityCache.put(guardedConstruct, applicability);
        }
        return applicability;
    }

    private GuardedConstructContext getOriginal() {
        return new GuardedConstructContext(this.equivalence.getOriginal(), this.context);
    }

    public void execute(ExecutableBlock<Void> body) throws EolRuntimeException {
        this.equivalence.ruleApplied(this.execution);
        if (body != null) {
            body.execute(this.context, this.equivalence.getVariables().toArray(new Variable[0]));
        }
    }
}

