/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.context;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;

public class MigrationStrategyCheckingContext {
    private final Model originalModel;
    private final FlockExecution execution;

    public MigrationStrategyCheckingContext(Model originalModel, FlockExecution execution) {
        this.originalModel = originalModel;
        this.execution = execution;
    }

    public boolean isTypeInOriginalMetamodel(String type) {
        return this.originalModel.hasType(type);
    }

    public boolean isPropertyInOriginalMetamodel(String type, String property) throws FlockRuntimeException {
        try {
            return this.originalModel.hasProperty(type, property);
        }
        catch (EolRuntimeException e) {
            throw new FlockRuntimeException("Could not check existence of " + type + "#" + property + " in original metamodel", e);
        }
    }

    public boolean isPackageInOriginalMetamodel(String originalPackage) {
        return this.originalModel.hasPackage(originalPackage);
    }

    public void addWarning(String warning) {
        this.execution.addWarning(warning);
    }
}

