/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.context;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.context.GuardedConstructContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.factory.EquivalenceFactory;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class TypeMappingContext {
    private final ModelElement original;
    private final IEolContext context;
    private final FlockExecution execution;
    private final EquivalenceEstablishmentContext.EquivalentFactory equivalentFactory;

    public TypeMappingContext(ModelElement original, IEolContext context, FlockExecution execution, EquivalenceEstablishmentContext.EquivalentFactory equivalentFactory) {
        this.original = original;
        this.context = context;
        this.execution = execution;
        this.equivalentFactory = equivalentFactory;
    }

    public boolean isEligibleFor(TypeMappingConstruct typeMapping) throws EolRuntimeException {
        return typeMapping.appliesIn(this.getOriginal());
    }

    private GuardedConstructContext getOriginal() {
        return new GuardedConstructContext(this.original, this.context);
    }

    public Equivalence createEquivalenceUsing(EquivalenceFactory equivalenceFactory) throws FlockRuntimeException {
        return equivalenceFactory.createEquivalence(this.context, this.execution, this.original, this.equivalentFactory);
    }
}

