/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.emc.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epsilon.flock.emc.wrappers.AttributeValue;
import org.eclipse.epsilon.flock.emc.wrappers.BackedModelValue;
import org.eclipse.epsilon.flock.emc.wrappers.CollectionOfModelValues;
import org.eclipse.epsilon.flock.emc.wrappers.EnumValue;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.emc.wrappers.ModelValue;

class ModelValueWrapper {
    private final Model model;

    ModelValueWrapper(Model model) {
        this.model = model;
    }

    ModelValue<?> wrapValue(Object value) {
        if (value instanceof BackedModelValue) {
            return (BackedModelValue)value;
        }
        if (this.model.isEnumeration(value) && !this.model.owns(value)) {
            return new EnumValue(this.model, value);
        }
        if (this.model.isModelElement(value)) {
            return this.wrapModelElement(value);
        }
        if (value instanceof Collection) {
            return new CollectionOfModelValues(this.model, this.wrapValues((Collection)value));
        }
        return new AttributeValue(this.model, value);
    }

    ModelElement wrapModelElement(Object object) {
        return ModelElement.create(this.model, object);
    }

    private Collection<ModelValue<?>> wrapValues(Collection<?> underlyingModelObjects) {
        ArrayList modelValues = new ArrayList(underlyingModelObjects.size());
        for (Object underlyingModelObject : underlyingModelObjects) {
            modelValues.add(this.model.wrap(underlyingModelObject));
        }
        return modelValues;
    }
}

