/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.equivalences;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.context.MigrateRuleContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;

public abstract class Equivalence {
    private final MigrateRuleContext context;

    public Equivalence(IEolContext context, FlockExecution execution) {
        this.context = new MigrateRuleContext(this, context, execution);
    }

    public MigrateRuleContext getContext() {
        return this.context;
    }

    public abstract ModelElement getOriginal();

    public abstract ModelElement getEquivalent();

    public abstract void ruleApplied(FlockExecution var1);

    public Collection<Variable> getVariables() {
        LinkedList<Variable> variables = new LinkedList<Variable>();
        variables.add(Equivalence.createVariable("original", this.getOriginal()));
        variables.add(Equivalence.createVariable("migrated", this.getEquivalent()));
        return variables;
    }

    private static Variable createVariable(String name, ModelElement element) {
        if (element == null) {
            return Variable.createReadOnlyVariable((String)name, null);
        }
        return element.createReadOnlyVariable(name);
    }

    public abstract void automaticallyPopulateEquivalent(ConservativeCopyContext var1, IgnoredProperties var2) throws FlockRuntimeException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

