/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.execute.context;

import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IReflectiveModel;
import org.eclipse.epsilon.erl.execute.context.ErlContext;
import org.eclipse.epsilon.flock.IFlockModule;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.FlockResult;
import org.eclipse.epsilon.flock.execute.context.IFlockContext;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.execute.exceptions.FlockUnsupportedModelException;
import org.eclipse.epsilon.flock.execute.operations.FlockOperationFactory;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;

public class FlockContext
extends ErlContext
implements IFlockContext {
    protected Model originalModel;
    protected Model migratedModel;
    private FlockExecution execution;

    public FlockContext() {
        this.setOperationFactory(new FlockOperationFactory());
    }

    public Model getOriginalModel() {
        return this.originalModel;
    }

    public Model getMigratedModel() {
        return this.migratedModel;
    }

    @Override
    public void setOriginalModel(IModel originalModel) throws FlockUnsupportedModelException {
        this.originalModel = this.addAndWrapModel(originalModel);
    }

    @Override
    public void setMigratedModel(IModel migratedModel) throws FlockUnsupportedModelException {
        this.migratedModel = this.addAndWrapModel(migratedModel);
    }

    private Model addAndWrapModel(IModel model) throws FlockUnsupportedModelException {
        if (model == null) {
            throw new NullPointerException("model cannot be null");
        }
        this.addModel(model);
        return this.wrapModel(model);
    }

    private void addModel(IModel model) {
        this.getModelRepository().addModel(model);
    }

    private Model wrapModel(IModel model) throws FlockUnsupportedModelException {
        if (model instanceof IReflectiveModel) {
            return new Model((IReflectiveModel)model, this.getPrettyPrinterManager());
        }
        throw new FlockUnsupportedModelException("Flock can only be used with models that implement IReflectiveModel. " + model.getName() + " does not.");
    }

    @Override
    public void setOriginalModel(int indexInRepository) throws FlockUnsupportedModelException {
        this.originalModel = this.getModelFromRepositoryByIndex(indexInRepository);
    }

    @Override
    public void setMigratedModel(int indexInRepository) throws FlockUnsupportedModelException {
        this.migratedModel = this.getModelFromRepositoryByIndex(indexInRepository);
    }

    private Model getModelFromRepositoryByIndex(int index) throws FlockUnsupportedModelException {
        return this.wrapModel((IModel)this.getModelRepository().getModels().get(index));
    }

    @Override
    public FlockResult execute(MigrationStrategy strategy) throws FlockRuntimeException {
        this.ensureRolesAreAssignedToModels();
        this.execution = new FlockExecution(this, strategy);
        return this.execution.run(this.originalModel);
    }

    private void ensureRolesAreAssignedToModels() throws FlockUnsupportedModelException {
        if (this.originalModel == null) {
            this.setOriginalModel(0);
        }
        if (this.migratedModel == null) {
            this.setMigratedModel(1);
        }
    }

    @Override
    public EquivalenceEstablishmentContext getEquivalenceEstablishmentContext() {
        return new EquivalenceEstablishmentContext(this.originalModel, this.migratedModel, (IEolContext)this, this.execution);
    }

    @Override
    public MigrationStrategyCheckingContext getMigrationStrategyCheckingContext() {
        return new MigrationStrategyCheckingContext(this.originalModel, this.execution);
    }

    @Override
    public ConservativeCopyContext getConservativeCopyContext() {
        return new ConservativeCopyContext(this.originalModel, this.migratedModel, this.execution);
    }

    public IFlockModule getModule() {
        return (IFlockModule)super.getModule();
    }
}

