/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.flock.context.MigrateRuleContext;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.context.TypeMappingContext;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;
import org.eclipse.epsilon.flock.model.domain.rules.MigrateRule;
import org.eclipse.epsilon.flock.model.domain.rules.MigrateRules;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstructs;

public class MigrationStrategy {
    protected List<ModuleElement> children = new LinkedList<ModuleElement>();
    protected TypeMappingConstructs typeMappingConstructs;
    protected MigrateRules migrateRules = new MigrateRules(new MigrateRule[0]);

    public MigrationStrategy(ClassifierTypedConstruct ... constructs) {
        ClassifierTypedConstruct[] classifierTypedConstructArray = constructs;
        int n = constructs.length;
        int n2 = 0;
        while (n2 < n) {
            ClassifierTypedConstruct construct = classifierTypedConstructArray[n2];
            if (construct instanceof TypeMappingConstruct) {
                this.addTypeMappingConstruct((TypeMappingConstruct)((Object)construct));
            } else if (construct instanceof MigrateRule) {
                this.addRule((MigrateRule)construct);
            } else {
                throw new IllegalArgumentException("constructs contains an unrecognsied construct: " + (Object)((Object)construct));
            }
            ++n2;
        }
    }

    public TypeMappingConstructs getTypeMappingConstructs() {
        if (this.typeMappingConstructs == null) {
            this.typeMappingConstructs = new TypeMappingConstructs(new TypeMappingConstruct[0]);
        }
        return this.typeMappingConstructs;
    }

    public Collection<ModuleElement> getTypeMappingsAndRules() {
        return this.children;
    }

    public void addTypeMappingConstruct(TypeMappingConstruct typeMappingConstruct) {
        this.getTypeMappingConstructs().add(typeMappingConstruct);
        this.children.add(typeMappingConstruct);
    }

    public Equivalence createEquivalence(TypeMappingContext context) throws EolRuntimeException {
        return this.getTypeMappingConstructs().createEquivalence(context);
    }

    public void addRule(MigrateRule rule) {
        this.migrateRules.add(rule);
        this.children.add((ModuleElement)rule);
    }

    public void checkTypeMappingsAndRules(MigrationStrategyCheckingContext context) {
        this.getTypeMappingConstructs().check(context);
        this.migrateRules.check(context);
    }

    public IgnoredProperties ignoredPropertiesFor(MigrateRuleContext context) throws EolRuntimeException {
        return this.migrateRules.ignoredPropertiesFor(context);
    }

    public void applyRulesTo(MigrateRuleContext context) throws EolRuntimeException {
        this.migrateRules.applyTo(context);
    }
}

