/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.common;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.flock.context.GuardedConstructContext;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.model.checker.ClassifierTypedConstructChecker;
import org.eclipse.epsilon.flock.model.domain.common.GuardedConstruct;

public abstract class ClassifierTypedConstruct
extends GuardedConstruct {
    private String originalType;

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.originalType = cst.getFirstChild().getText();
        if (this.originalType == null) {
            throw new IllegalStateException("originalType cannot be null");
        }
    }

    public String getOriginalType() {
        return this.originalType;
    }

    protected boolean isStrict() {
        return this.hasAnnotation("strict");
    }

    @Override
    public boolean appliesIn(GuardedConstructContext context) throws EolRuntimeException {
        return this.typedFor(context) && super.appliesIn(context);
    }

    protected boolean typedFor(GuardedConstructContext context) {
        return context.originalConformsTo(this.originalType, this.isStrict());
    }

    public void check(MigrationStrategyCheckingContext context) {
        new ClassifierTypedConstructChecker(this.originalType, context).check();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ClassifierTypedConstruct)) {
            return false;
        }
        ClassifierTypedConstruct other = (ClassifierTypedConstruct)((Object)object);
        return super.equals((Object)other) && this.originalType.equals(other.originalType);
    }

    public int hashCode() {
        return super.hashCode() + this.originalType.hashCode();
    }
}

