/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.common;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.flock.context.GuardedConstructContext;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.model.checker.PackageTypedConstructChecker;
import org.eclipse.epsilon.flock.model.domain.common.GuardedConstruct;

public abstract class PackageTypedConstruct
extends GuardedConstruct {
    private String originalPackage;

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.originalPackage = cst.getFirstChild().getText();
        if (this.originalPackage == null) {
            throw new IllegalArgumentException("originalPackage cannot be null");
        }
    }

    public String getOriginalPackage() {
        return this.originalPackage;
    }

    @Override
    public boolean appliesIn(GuardedConstructContext context) throws EolRuntimeException {
        return context.originalBelongsTo(this.originalPackage) && super.appliesIn(context);
    }

    public void check(MigrationStrategyCheckingContext context) {
        new PackageTypedConstructChecker(this.originalPackage, context).check();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PackageTypedConstruct)) {
            return false;
        }
        PackageTypedConstruct other = (PackageTypedConstruct)((Object)object);
        return super.equals((Object)other) && this.originalPackage.equals(other.originalPackage);
    }

    public int hashCode() {
        return super.hashCode() + this.originalPackage.hashCode();
    }
}

