/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.model.checker.IgnoredPropertyChecker;

public class IgnoredProperties {
    private final Collection<String> ignoredProperties = new LinkedList<String>();

    public IgnoredProperties(String ... ignoredProperties) {
        this(Arrays.asList(ignoredProperties));
    }

    public IgnoredProperties(Collection<String> ignoredProperties) {
        this.ignoredProperties.addAll(ignoredProperties);
    }

    public void add(String ignoredProperty) {
        this.ignoredProperties.add(ignoredProperty);
    }

    public void addAll(IgnoredProperties other) {
        this.ignoredProperties.addAll(other.ignoredProperties);
    }

    public boolean isNotIgnored(String propertyName) {
        return !this.isIgnored(propertyName);
    }

    private boolean isIgnored(String propertyName) {
        return this.ignoredProperties.contains(propertyName);
    }

    public boolean isEmpty() {
        return this.ignoredProperties.isEmpty();
    }

    public void check(String originalType, MigrationStrategyCheckingContext context) {
        IgnoredPropertyChecker checker = new IgnoredPropertyChecker(originalType, context);
        for (String ignoredProperty : this.ignoredProperties) {
            checker.check(ignoredProperty);
        }
    }

    public String toString() {
        return this.ignoredProperties.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IgnoredProperties)) {
            return false;
        }
        IgnoredProperties other = (IgnoredProperties)object;
        return this.ignoredProperties.equals(other.ignoredProperties);
    }

    public int hashCode() {
        return this.ignoredProperties.hashCode();
    }
}

