/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.rules;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.flock.context.MigrateRuleContext;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;

public class MigrateRule
extends ClassifierTypedConstruct {
    private ExecutableBlock<Void> body;
    private final IgnoredProperties ignoredProperties = new IgnoredProperties(new String[0]);

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.body = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)67), (ModuleElement)this);
        AST ignoring = AstUtil.getChild((AST)cst, (int)92);
        if (ignoring != null) {
            for (AST ignoredProperty : ignoring.getChildren()) {
                this.ignoredProperties.add(ignoredProperty.getText());
            }
        }
    }

    public IgnoredProperties getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public String getDescriptionOfIgnoredProperties() {
        return this.ignoredProperties.isEmpty() ? "" : "ignoring " + this.ignoredProperties;
    }

    @Override
    public void check(MigrationStrategyCheckingContext context) {
        super.check(context);
        this.ignoredProperties.check(this.getOriginalType(), context);
    }

    public void gatherIgnoredPropertiesFor(MigrateRuleContext context, IgnoredProperties ignoredProperties) throws EolRuntimeException {
        boolean applicable = context.isEligibleFor(this);
        if (applicable) {
            ignoredProperties.addAll(this.ignoredProperties);
        }
    }

    public boolean applyTo(MigrateRuleContext context) throws EolRuntimeException {
        boolean applicable = context.isEligibleFor(this);
        if (applicable) {
            context.execute(this.body);
        }
        return applicable;
    }

    public String toString() {
        return (this.getAnnotationBlock() == null ? "" : this.getAnnotationBlock()) + "migrate " + this.getOriginalType() + " " + "ignoring " + this.ignoredProperties + " " + "when " + this.getGuard() + " " + "do " + this.body;
    }
}

