/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.typemappings;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.NoEquivalence;
import org.eclipse.epsilon.flock.equivalences.TypeBasedEquivalence;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.PackageTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class PackageRetyping
extends PackageTypedConstruct
implements TypeMappingConstruct {
    private String evolvedPackage;

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.evolvedPackage = cst.getSecondChild().getText();
        if (this.evolvedPackage == null) {
            throw new IllegalArgumentException("evolvedPackage cannot be null");
        }
    }

    public String getEvolvedPackage() {
        return this.evolvedPackage;
    }

    @Override
    public Equivalence createEquivalence(IEolContext context, FlockExecution execution, ModelElement original, EquivalenceEstablishmentContext.EquivalentFactory factory) throws FlockRuntimeException {
        String equivalentType = String.valueOf(this.evolvedPackage) + "::" + original.getUnqualifiedTypeName();
        if (factory.typeConformsToEvolvedMetamodel(equivalentType)) {
            ModelElement equivalent = factory.createModelElementInMigratedModel(equivalentType);
            return new TypeBasedEquivalence(context, execution, original, equivalent);
        }
        return new NoEquivalence(context, execution, original);
    }

    public String toString() {
        return "retype package " + this.getOriginalPackage() + " to " + this.evolvedPackage + " when " + this.getGuard();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PackageRetyping)) {
            return false;
        }
        PackageRetyping other = (PackageRetyping)object;
        return super.equals(object) && this.evolvedPackage.equals(other.evolvedPackage);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.evolvedPackage.hashCode();
    }
}

