/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.typemappings;

import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.flock.context.EquivalenceEstablishmentContext;
import org.eclipse.epsilon.flock.emc.wrappers.ModelElement;
import org.eclipse.epsilon.flock.equivalences.Equivalence;
import org.eclipse.epsilon.flock.equivalences.TypeBasedEquivalence;
import org.eclipse.epsilon.flock.execute.FlockExecution;
import org.eclipse.epsilon.flock.execute.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.typemappings.TypeMappingConstruct;

public class Retyping
extends ClassifierTypedConstruct
implements TypeMappingConstruct {
    private String evolvedType;

    @Override
    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.evolvedType = cst.getSecondChild().getText();
        if (this.evolvedType == null) {
            throw new IllegalStateException("evolvedType cannot be null");
        }
    }

    public String getEvolvedType() {
        return this.evolvedType;
    }

    @Override
    public Equivalence createEquivalence(IEolContext context, FlockExecution execution, ModelElement original, EquivalenceEstablishmentContext.EquivalentFactory factory) throws FlockRuntimeException {
        ModelElement equivalent = factory.createModelElementInMigratedModel(this.evolvedType);
        return new TypeBasedEquivalence(context, execution, original, equivalent);
    }

    public String toString() {
        return "retype " + this.getOriginalType() + " to " + this.evolvedType + " when " + this.getGuard();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Retyping)) {
            return false;
        }
        Retyping other = (Retyping)object;
        return super.equals(object) && this.evolvedType.equals(other.evolvedType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.evolvedType.hashCode();
    }
}

