/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.mock;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.gemini.blueprint.mock.ArrayEnumerator;
import org.eclipse.gemini.blueprint.mock.MockBundle;
import org.osgi.framework.BundleContext;

public class EntryLookupControllingMockBundle
extends MockBundle {
    protected Enumeration nextFindResult = null;
    protected URL nextEntryResult = null;

    public EntryLookupControllingMockBundle(Dictionary headers) {
        super(headers);
    }

    public void setResultsToReturnOnNextCallToFindEntries(String[] findResult) {
        if (findResult == null) {
            findResult = new String[]{};
        }
        this.nextFindResult = this.createEnumerationOver(findResult);
    }

    @Override
    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        if (this.nextFindResult == null) {
            return super.findEntries(path, filePattern, recurse);
        }
        Enumeration ret = this.nextFindResult;
        this.nextFindResult = null;
        return ret;
    }

    public void setEntryReturnOnNextCallToGetEntry(URL entry) {
        this.nextEntryResult = entry;
    }

    @Override
    public URL getEntry(String name) {
        if (this.nextEntryResult != null) {
            URL result = this.nextEntryResult;
            this.nextEntryResult = null;
            return result;
        }
        return super.getEntry(name);
    }

    @Override
    public URL getResource(String name) {
        return this.getEntry(name);
    }

    @Override
    public BundleContext getContext() {
        return super.getContext();
    }

    protected Enumeration createEnumerationOver(String[] entries) {
        return new ArrayEnumerator<String>(entries);
    }
}

