/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.ResourceIdentifier;

public final class MappedMessage {
    private final ResourceIdentifier targetAddress;
    private final Buffer payload;
    private final Map<String, String> additionalProperties = new HashMap<String, String>();

    public MappedMessage(ResourceIdentifier targetAddress, Buffer payload) {
        this(targetAddress, payload, null);
    }

    public MappedMessage(ResourceIdentifier targetAddress, Buffer payload, Map<String, String> additionalProperties) {
        this.targetAddress = Objects.requireNonNull(targetAddress);
        this.payload = Optional.ofNullable(payload).orElseGet(Buffer::buffer);
        Optional.ofNullable(additionalProperties).ifPresent(props -> this.additionalProperties.putAll(additionalProperties));
    }

    public ResourceIdentifier getTargetAddress() {
        return this.targetAddress;
    }

    public Buffer getPayload() {
        return this.payload;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }
}

