/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import org.eclipse.hono.adapter.mqtt.MqttProtocolAdapterOptions;
import org.eclipse.hono.config.ProtocolAdapterProperties;

public class MqttProtocolAdapterProperties
extends ProtocolAdapterProperties {
    protected static final int DEFAULT_COMMAND_ACK_TIMEOUT = 100;
    protected static final long DEFAULT_SEND_MESSAGE_TO_DEVICE_TIMEOUT = 1000L;
    private int commandAckTimeout = 100;
    private long sendMessageToDeviceTimeout = 1000L;

    public MqttProtocolAdapterProperties() {
    }

    public MqttProtocolAdapterProperties(MqttProtocolAdapterOptions options) {
        super(options.adapterOptions());
        this.setCommandAckTimeout(options.commandAckTimeout());
        this.setSendMessageToDeviceTimeout(options.sendMessageToDeviceTimeout());
    }

    @Deprecated(forRemoval=true)
    public final int getCommandAckTimeout() {
        return this.commandAckTimeout;
    }

    @Deprecated(forRemoval=true)
    public final void setCommandAckTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        this.commandAckTimeout = timeout;
    }

    public final long getSendMessageToDeviceTimeout() {
        return this.sendMessageToDeviceTimeout;
    }

    public final void setSendMessageToDeviceTimeout(long sendMessageToDeviceTimeout) {
        if (sendMessageToDeviceTimeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        this.sendMessageToDeviceTimeout = sendMessageToDeviceTimeout;
    }

    long getEffectiveSendMessageToDeviceTimeout() {
        if (this.sendMessageToDeviceTimeout == 1000L && this.commandAckTimeout != 100) {
            return this.commandAckTimeout;
        }
        return this.sendMessageToDeviceTimeout;
    }
}

