/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.MultiMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyBag {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBag.class);
    private final MultiMap properties;
    private final ResourceIdentifier topicWithoutPropertyBag;

    private PropertyBag(ResourceIdentifier topicWithoutPropertyBag, MultiMap properties) {
        this.topicWithoutPropertyBag = topicWithoutPropertyBag;
        this.properties = properties;
    }

    public static PropertyBag fromTopic(String topic) {
        PropertyBag propertyBag;
        Objects.requireNonNull(topic);
        if (topic.isEmpty() || topic.startsWith("/")) {
            return null;
        }
        int index = topic.lastIndexOf("/?");
        if (index == 0) {
            propertyBag = null;
        } else if (index > 0) {
            MultiMap properties = null;
            try {
                properties = new QueryStringDecoder(topic.substring(index)).parameters().entrySet().stream().collect(MultiMap::caseInsensitiveMultiMap, (multiMap, entry) -> multiMap.add((String)entry.getKey(), (Iterable)entry.getValue()), MultiMap::addAll);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("invalid property bag", (Throwable)e);
            }
            propertyBag = properties != null ? new PropertyBag(ResourceIdentifier.fromString((String)topic.substring(0, index)), properties) : null;
        } else {
            propertyBag = new PropertyBag(ResourceIdentifier.fromString((String)topic), MultiMap.caseInsensitiveMultiMap());
        }
        return propertyBag;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Iterator<Map.Entry<String, String>> getPropertiesIterator() {
        return this.properties.iterator();
    }

    public ResourceIdentifier topicWithoutPropertyBag() {
        return this.topicWithoutPropertyBag;
    }
}

