// CHECKSTYLE:OFF

package hudson.cli.client;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Hudson CLI
     * Usage: java -jar hudson-cli.jar [-s URL] command [opts...] args...
     * Options:
     *  -s URL : specify the server URL (defaults to the HUDSON_URL env var)
     * 
     * The available commands depend on the server. Run the 'help' command to
     * see the list.
     * 
     */
    public static String CLI_Usage() {
        return holder.format("CLI.Usage");
    }

    /**
     * Hudson CLI
     * Usage: java -jar hudson-cli.jar [-s URL] command [opts...] args...
     * Options:
     *  -s URL : specify the server URL (defaults to the HUDSON_URL env var)
     * 
     * The available commands depend on the server. Run the 'help' command to
     * see the list.
     * 
     */
    public static Localizable _CLI_Usage() {
        return new Localizable(holder, "CLI.Usage");
    }

    /**
     * Neither -s nor the HUDSON_URL env var is specified.
     * 
     */
    public static String CLI_NoURL() {
        return holder.format("CLI.NoURL");
    }

    /**
     * Neither -s nor the HUDSON_URL env var is specified.
     * 
     */
    public static Localizable _CLI_NoURL() {
        return new Localizable(holder, "CLI.NoURL");
    }

    /**
     * Version mismatch. This CLI cannot work with this Hudson server
     * 
     */
    public static String CLI_VersionMismatch() {
        return holder.format("CLI.VersionMismatch");
    }

    /**
     * Version mismatch. This CLI cannot work with this Hudson server
     * 
     */
    public static Localizable _CLI_VersionMismatch() {
        return new Localizable(holder, "CLI.VersionMismatch");
    }

}
