/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class BinarySafeStream {
    private static final byte[] ENCODING_TABLE;
    private static final int[] DECODING_TABLE;

    private BinarySafeStream() {
    }

    public static InputStream wrap(InputStream in) {
        return new FilterInputStream(in){
            final byte[] triplet = new byte[4];
            int remaining = 0;
            final byte[] qualtet = new byte[4];
            int input = 0;

            public int read() throws IOException {
                if (this.remaining == 0) {
                    this.remaining = this._read(this.triplet, 0, 3);
                    if (0 < this.remaining && this.remaining < 3) {
                        System.arraycopy(this.triplet, 0, this.triplet, 3 - this.remaining, this.remaining);
                    }
                }
                if (this.remaining == -1) {
                    return -1;
                }
                assert (this.remaining > 0);
                return this.triplet[3 - this.remaining--] & 0xFF;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (this.remaining == -1) {
                    return -1;
                }
                if (len < 4) {
                    int ch;
                    int read = 0;
                    while (len > 0 && (ch = this.read()) != -1) {
                        b[off++] = (byte)ch;
                        ++read;
                        --len;
                    }
                    return read;
                }
                int l = Math.min(len, this.remaining);
                if (l > 0) {
                    System.arraycopy(this.triplet, 3 - this.remaining, b, off, l);
                    off += l;
                    len -= l;
                    this.remaining = 0;
                    if (super.available() == 0) {
                        return l;
                    }
                    if (len < 4) {
                        return l;
                    }
                    int r = this._read(b, off, len);
                    if (r == -1) {
                        return l;
                    }
                    return l + r;
                }
                return this._read(b, off, len);
            }

            private int _read(byte[] b, int off, int len) throws IOException {
                assert (this.remaining == 0);
                assert (b.length >= off + 4);
                int totalRead = 0;
                if (len > 0) {
                    int l;
                    int r;
                    if (this.input > 0) {
                        System.arraycopy(this.qualtet, 0, b, off, this.input);
                    }
                    for (l = this.input; l < 4; l += r) {
                        r = super.read(b, off + l, Math.max(len, 4) - l);
                        if (r != -1) continue;
                        if (l % 4 != 0) {
                            throw new IOException("Unexpected stream termination");
                        }
                        if (l != 0) continue;
                        return -1;
                    }
                    this.input = l % 4;
                    if (this.input > 0) {
                        System.arraycopy(b, off + l - this.input, this.qualtet, 0, this.input);
                        l -= this.input;
                    }
                    assert (l % 4 == 0);
                    int base = off;
                    while (l > 0) {
                        int c0 = DECODING_TABLE[b[base++]];
                        int c1 = DECODING_TABLE[b[base++]];
                        int c2 = DECODING_TABLE[b[base++]];
                        int c3 = DECODING_TABLE[b[base++]];
                        if (c0 < 0 || c1 < 0 || c2 < -1 || c3 < -1) {
                            Object buf;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            baos.write(b, base - 4, l);
                            int avail = super.available();
                            if (avail > 0) {
                                buf = new byte[avail];
                                baos.write((byte[])buf, 0, super.read((byte[])buf));
                            }
                            buf = new StringBuilder("Invalid encoded sequence encountered:");
                            for (byte ch : baos.toByteArray()) {
                                ((StringBuilder)buf).append(String.format(" %02X", ch));
                            }
                            throw new IOException(((StringBuilder)buf).toString());
                        }
                        b[off++] = (byte)(c0 << 2 | c1 >> 4);
                        ++totalRead;
                        if (c2 != -1) {
                            b[off++] = (byte)(c1 << 4 | c2 >> 2);
                            ++totalRead;
                            if (c3 != -1) {
                                b[off++] = (byte)(c2 << 6 | c3);
                                ++totalRead;
                            }
                        }
                        l -= 4;
                    }
                }
                return totalRead;
            }

            public int available() throws IOException {
                return super.available() * 3 / 4;
            }
        };
    }

    public static OutputStream wrap(OutputStream out) {
        return new FilterOutputStream(out){
            private final byte[] triplet = new byte[3];
            private int remaining = 0;
            private final byte[] out = new byte[4];

            public void write(int b) throws IOException {
                if (this.remaining == 2) {
                    this._write(this.triplet[0], this.triplet[1], (byte)b);
                    this.remaining = 0;
                } else {
                    this.triplet[this.remaining++] = (byte)b;
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                if (this.remaining > 0) {
                    while (len > 0 && this.remaining < 3) {
                        this.triplet[this.remaining++] = b[off++];
                        --len;
                    }
                    if (this.remaining == 3) {
                        this._write(this.triplet[0], this.triplet[1], this.triplet[2]);
                        this.remaining = 0;
                    }
                }
                while (len >= 3) {
                    this._write(b[off++], b[off++], b[off++]);
                    len -= 3;
                }
                assert (0 <= len && len < 3);
                while (len > 0) {
                    this.triplet[this.remaining++] = b[off++];
                    --len;
                }
            }

            private void _write(byte a, byte b, byte c) throws IOException {
                this.out[0] = ENCODING_TABLE[a >> 2 & 0x3F];
                this.out[1] = ENCODING_TABLE[a << 4 & 0x3F | b >> 4 & 0xF];
                this.out[2] = ENCODING_TABLE[b << 2 & 0x3F | c >> 6 & 3];
                this.out[3] = ENCODING_TABLE[c & 0x3F];
                ((FilterOutputStream)this).out.write(this.out, 0, 4);
            }

            public void flush() throws IOException {
                int a = this.triplet[0];
                int b = this.triplet[1];
                a &= 0xFF;
                b &= 0xFF;
                switch (this.remaining) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.out[0] = ENCODING_TABLE[a >> 2 & 0x3F];
                        this.out[1] = ENCODING_TABLE[a << 4 & 0x3F];
                        this.out[2] = 61;
                        this.out[3] = 61;
                        ((FilterOutputStream)this).out.write(this.out, 0, 4);
                        this.remaining = 0;
                        break;
                    }
                    case 2: {
                        this.out[0] = ENCODING_TABLE[a >> 2 & 0x3F];
                        this.out[1] = ENCODING_TABLE[(a << 4 | b >> 4) & 0x3F];
                        this.out[2] = ENCODING_TABLE[b << 2 & 0x3F];
                        this.out[3] = 61;
                        ((FilterOutputStream)this).out.write(this.out, 0, 4);
                        this.remaining = 0;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                super.flush();
            }
        };
    }

    static {
        DECODING_TABLE = new int[128];
        try {
            ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        Arrays.fill(DECODING_TABLE, -2);
        for (int i = 0; i < ENCODING_TABLE.length; ++i) {
            BinarySafeStream.DECODING_TABLE[BinarySafeStream.ENCODING_TABLE[i]] = i;
        }
        BinarySafeStream.DECODING_TABLE[61] = -1;
    }
}

