/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.id;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.UUID;
import org.hudsonci.utils.id.ID;

@XStreamAlias(value="guid")
public class GUID
implements ID {
    @XStreamAsAttribute
    private final UUID value;

    public GUID(UUID value) {
        this.value = (UUID)Preconditions.checkNotNull((Object)value);
    }

    public GUID(String value) {
        this(UUID.fromString(value));
    }

    public GUID() {
        this(UUID.randomUUID());
    }

    public UUID getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GUID)) {
            return false;
        }
        GUID that = (GUID)obj;
        return !(this.value == null ? that.value != null : !this.value.equals(that.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return this.value.toString();
    }
}

