/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScanningAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private Map<String, App> _appMap = new HashMap<String, App>();
    private DeploymentManager _deploymentManager;
    protected final FilenameFilter _filenameFilter;
    private Resource _monitoredDir;
    private boolean _recursive = false;
    private int _scanInterval = 10;
    private Scanner _scanner;
    private final Scanner.DiscreteListener _scannerListener = new Scanner.DiscreteListener(){

        public void fileAdded(String filename) throws Exception {
            ScanningAppProvider.this.fileAdded(filename);
        }

        public void fileChanged(String filename) throws Exception {
            ScanningAppProvider.this.fileChanged(filename);
        }

        public void fileRemoved(String filename) throws Exception {
            ScanningAppProvider.this.fileRemoved(filename);
        }
    };

    protected ScanningAppProvider(FilenameFilter filter) {
        this._filenameFilter = filter;
    }

    protected Map<String, App> getDeployedApps() {
        return this._appMap;
    }

    protected App createApp(String filename) {
        return new App(this._deploymentManager, this, filename);
    }

    @Override
    protected void doStart() throws Exception {
        if (Log.isDebugEnabled()) {
            Log.debug(this.getClass().getSimpleName() + ".doStart()");
        }
        if (this._monitoredDir == null) {
            throw new IllegalStateException("No configuration dir specified");
        }
        File scandir = this._monitoredDir.getFile();
        Log.info("Deployment monitor " + scandir + " at interval " + this._scanInterval);
        this._scanner = new Scanner();
        this._scanner.setScanDirs(Collections.singletonList(scandir));
        this._scanner.setScanInterval(this._scanInterval);
        this._scanner.setRecursive(this._recursive);
        this._scanner.setFilenameFilter(this._filenameFilter);
        this._scanner.setReportDirs(true);
        this._scanner.addListener(this._scannerListener);
        this._scanner.start();
    }

    @Override
    protected void doStop() throws Exception {
        if (this._scanner != null) {
            this._scanner.stop();
            this._scanner.removeListener(this._scannerListener);
            this._scanner = null;
        }
    }

    protected void fileAdded(String filename) throws Exception {
        App app;
        if (Log.isDebugEnabled()) {
            Log.debug("added ", filename);
        }
        if ((app = this.createApp(filename)) != null) {
            this._appMap.put(filename, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void fileChanged(String filename) throws Exception {
        App app;
        if (Log.isDebugEnabled()) {
            Log.debug("changed ", filename);
        }
        if ((app = this._appMap.remove(filename)) != null) {
            this._deploymentManager.removeApp(app);
        }
        if ((app = this.createApp(filename)) != null) {
            this._appMap.put(filename, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void fileRemoved(String filename) throws Exception {
        App app;
        if (Log.isDebugEnabled()) {
            Log.debug("removed ", filename);
        }
        if ((app = this._appMap.remove(filename)) != null) {
            this._deploymentManager.removeApp(app);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Resource getMonitoredDirResource() {
        return this._monitoredDir;
    }

    public String getMonitoredDirName() {
        return this._monitoredDir.toString();
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    @Override
    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public void setMonitoredDirResource(Resource contextsDir) {
        this._monitoredDir = contextsDir;
    }

    public void addScannerListener(Scanner.Listener listener) {
        this._scanner.addListener(listener);
    }

    public void setMonitoredDirName(String dir) {
        try {
            this.setMonitoredDirResource(Resource.newResource(dir));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
    }
}

