/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.plus.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.plus.jaas.spi.UserInfo;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = Log.getLogger(PropertyFileLoginModule.class);
    private static ConcurrentHashMap<String, PropertyUserStore> _propertyUserStores = new ConcurrentHashMap();
    private int _refreshInterval = 0;
    private String _filename = "realm.properties";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        this.parseConfig(options);
        if (_propertyUserStores.get(this._filename) == null) {
            PropertyUserStore propertyUserStore = new PropertyUserStore();
            propertyUserStore.setConfig(this._filename);
            propertyUserStore.setRefreshInterval(this._refreshInterval);
            PropertyUserStore prev = _propertyUserStores.putIfAbsent(this._filename, propertyUserStore);
            if (prev == null) {
                LOG.debug("setupPropertyUserStore: Starting new PropertyUserStore. PropertiesFile: " + this._filename + " refreshInterval: " + this._refreshInterval, new Object[0]);
                try {
                    propertyUserStore.start();
                }
                catch (Exception e) {
                    LOG.warn("Exception while starting propertyUserStore: ", e);
                }
            }
        }
    }

    private void parseConfig(Map<String, ?> options) {
        this._filename = (String)options.get("file");
        this._filename = this._filename == null ? DEFAULT_FILENAME : this._filename;
        String refreshIntervalString = (String)options.get("refreshInterval");
        this._refreshInterval = refreshIntervalString == null ? this._refreshInterval : Integer.parseInt(refreshIntervalString);
    }

    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        PropertyUserStore propertyUserStore = _propertyUserStores.get(this._filename);
        if (propertyUserStore == null) {
            throw new IllegalStateException("PropertyUserStore should never be null here!");
        }
        LOG.debug("Checking PropertyUserStore " + this._filename + " for " + userName, new Object[0]);
        UserIdentity userIdentity = propertyUserStore.getUserIdentity(userName);
        if (userIdentity == null) {
            return null;
        }
        Set<Principal> principals = userIdentity.getSubject().getPrincipals();
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal principal : principals) {
            roles.add(principal.getName());
        }
        Credential credential = (Credential)userIdentity.getSubject().getPrivateCredentials().iterator().next();
        LOG.debug("Found: " + userName + " in PropertyUserStore " + this._filename, new Object[0]);
        return new UserInfo(userName, credential, roles);
    }
}

