/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;

public class DeferredContentProvider
implements AsyncContentProvider,
AutoCloseable {
    private static final ByteBuffer CLOSE = ByteBuffer.allocate(0);
    private final Queue<ByteBuffer> chunks = new ConcurrentLinkedQueue<ByteBuffer>();
    private final AtomicReference<AsyncContentProvider.Listener> listener = new AtomicReference();
    private final Iterator<ByteBuffer> iterator = new DeferredContentProviderIterator();
    private final AtomicBoolean closed = new AtomicBoolean();

    public DeferredContentProvider(ByteBuffer ... buffers) {
        for (ByteBuffer buffer : buffers) {
            this.chunks.offer(buffer);
        }
    }

    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        if (!this.listener.compareAndSet(null, listener)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public long getLength() {
        return -1L;
    }

    public boolean offer(ByteBuffer buffer) {
        boolean result = this.chunks.offer(buffer);
        this.notifyListener();
        return result;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.chunks.offer(CLOSE);
            this.notifyListener();
        }
    }

    private void notifyListener() {
        AsyncContentProvider.Listener listener = this.listener.get();
        if (listener != null) {
            listener.onContent();
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.iterator;
    }

    private class DeferredContentProviderIterator
    implements Iterator<ByteBuffer> {
        private DeferredContentProviderIterator() {
        }

        @Override
        public boolean hasNext() {
            return DeferredContentProvider.this.chunks.peek() != CLOSE;
        }

        @Override
        public ByteBuffer next() {
            ByteBuffer element = (ByteBuffer)DeferredContentProvider.this.chunks.poll();
            if (element == CLOSE) {
                throw new NoSuchElementException();
            }
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

