/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Settings
implements Iterable<Setting> {
    private Map<ID, Setting> settings = new HashMap<ID, Setting>();

    public Settings() {
    }

    public Settings(Settings original, boolean immutable) {
        HashMap<ID, Setting> copy = new HashMap<ID, Setting>(original.size());
        copy.putAll(original.settings);
        this.settings = immutable ? Collections.unmodifiableMap(copy) : copy;
    }

    public Setting get(ID id) {
        return this.settings.get(id);
    }

    public void put(Setting setting) {
        this.settings.put(setting.id(), setting);
    }

    public Setting remove(ID id) {
        return this.settings.remove(id);
    }

    public int size() {
        return this.settings.size();
    }

    public void clear() {
        this.settings.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Settings that = (Settings)obj;
        return this.settings.equals(that.settings);
    }

    public int hashCode() {
        return this.settings.hashCode();
    }

    @Override
    public Iterator<Setting> iterator() {
        return this.settings.values().iterator();
    }

    public String toString() {
        return this.settings.toString();
    }

    public static class Setting {
        private final ID id;
        private final Flag flag;
        private final int value;

        public Setting(ID id, int value) {
            this(id, Flag.NONE, value);
        }

        public Setting(ID id, Flag flag, int value) {
            this.id = id;
            this.flag = flag;
            this.value = value;
        }

        public ID id() {
            return this.id;
        }

        public Flag flag() {
            return this.flag;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Setting that = (Setting)obj;
            return this.value == that.value && this.flag == that.flag && this.id == that.id;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.flag.hashCode();
            result = 31 * result + this.value;
            return result;
        }

        public String toString() {
            return String.format("[id=%s,flags=%s:value=%d]", new Object[]{this.id(), this.flag(), this.value()});
        }
    }

    public static enum Flag {
        NONE(0),
        PERSIST(1),
        PERSISTED(2);

        private final byte code;

        public static Flag from(byte code) {
            return (Flag)((Object)Codes.codes.get(code));
        }

        private Flag(byte code) {
            this.code = code;
            Codes.codes.put(code, this);
        }

        public byte code() {
            return this.code;
        }

        private static class Codes {
            private static final Map<Byte, Flag> codes = new HashMap<Byte, Flag>();

            private Codes() {
            }
        }
    }

    public static final class ID {
        public static ID UPLOAD_BANDWIDTH = new ID(1);
        public static ID DOWNLOAD_BANDWIDTH = new ID(2);
        public static ID ROUND_TRIP_TIME = new ID(3);
        public static ID MAX_CONCURRENT_STREAMS = new ID(4);
        public static ID CURRENT_CONGESTION_WINDOW = new ID(5);
        public static ID DOWNLOAD_RETRANSMISSION_RATE = new ID(6);
        public static ID INITIAL_WINDOW_SIZE = new ID(7);
        private final int code;

        public static synchronized ID from(int code) {
            ID id = (ID)Codes.codes.get(code);
            if (id == null) {
                id = new ID(code);
            }
            return id;
        }

        private ID(int code) {
            this.code = code;
            Codes.codes.put(code, this);
        }

        public int code() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code);
        }

        private static class Codes {
            private static final Map<Integer, ID> codes = new HashMap<Integer, ID>();

            private Codes() {
            }
        }
    }
}

