/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.util.HashMap;
import java.util.Map;

public enum HTTPSPDYHeader {
    METHOD("method", ":method"),
    URI("url", ":path"),
    VERSION("version", ":version"),
    SCHEME("scheme", ":scheme"),
    HOST("host", ":host"),
    STATUS("status", ":status");

    private final String v2Name;
    private final String v3Name;

    public static HTTPSPDYHeader from(short version, String name) {
        switch (version) {
            case 2: {
                return (HTTPSPDYHeader)((Object)Names.v2Names.get(name));
            }
            case 3: {
                return (HTTPSPDYHeader)((Object)Names.v3Names.get(name));
            }
        }
        throw new IllegalStateException();
    }

    private HTTPSPDYHeader(String v2Name, String v3Name) {
        this.v2Name = v2Name;
        Names.v2Names.put(v2Name, this);
        this.v3Name = v3Name;
        Names.v3Names.put(v3Name, this);
    }

    public String name(short version) {
        switch (version) {
            case 2: {
                return this.v2Name;
            }
            case 3: {
                return this.v3Name;
            }
        }
        throw new IllegalStateException();
    }

    private static class Names {
        private static final Map<String, HTTPSPDYHeader> v2Names = new HashMap<String, HTTPSPDYHeader>();
        private static final Map<String, HTTPSPDYHeader> v3Names = new HashMap<String, HTTPSPDYHeader>();

        private Names() {
        }
    }
}

