/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.common.message.SimpleTextMessage;

public class ListenerEventDriver
extends EventDriver {
    private static final Logger LOG = Log.getLogger(ListenerEventDriver.class);
    private final WebSocketListener listener;
    private MessageAppender activeMessage;
    private boolean hasCloseBeenCalled = false;

    public ListenerEventDriver(WebSocketPolicy policy, WebSocketListener listener) {
        super(policy, listener);
        this.listener = listener;
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            this.activeMessage = new SimpleBinaryMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        this.listener.onWebSocketBinary(data, 0, data.length);
    }

    @Override
    public void onClose(CloseInfo close) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        int statusCode = close.getStatusCode();
        String reason = close.getReason();
        this.listener.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onConnect() {
        LOG.debug("onConnect()", new Object[0]);
        this.listener.onWebSocketConnect(this.session);
    }

    @Override
    public void onError(Throwable cause) {
        this.listener.onWebSocketError(cause);
    }

    @Override
    public void onFrame(Frame frame) {
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            this.activeMessage = new SimpleTextMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onTextMessage(String message) {
        this.listener.onWebSocketText(message);
    }
}

